<?php

namespace PHPMaker2024\fibre;

// Page object
$ApcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { apc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fapcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fapcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["apcid", [ew.Validators.integer], fields.apcid.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["cron", [], fields.cron.isInvalid],
            ["next_cycle", [ew.Validators.datetime(fields.next_cycle.clientFormatPattern)], fields.next_cycle.isInvalid],
            ["delay", [ew.Validators.integer], fields.delay.isInvalid],
            ["delay_method", [], fields.delay_method.isInvalid],
            ["last_updated", [], fields.last_updated.isInvalid],
            ["user_level", [], fields.user_level.isInvalid],
            ["_visible", [], fields._visible.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["order_by", [ew.Validators.integer], fields.order_by.isInvalid],
            ["url", [], fields.url.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "cron": <?= $Page->cron->toClientList($Page) ?>,
            "delay_method": <?= $Page->delay_method->toClientList($Page) ?>,
            "user_level": <?= $Page->user_level->toClientList($Page) ?>,
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fapcsearch" id="fapcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->apcid->Visible) { // apcid ?>
    <div id="r_apcid" class="row"<?= $Page->apcid->rowAttributes() ?>>
        <label for="x_apcid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_apcid"><?= $Page->apcid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_apcid" id="z_apcid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->apcid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_apcid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->apcid->getInputTextType() ?>" name="x_apcid" id="x_apcid" data-table="apc" data-field="x_apcid" value="<?= $Page->apcid->EditValue ?>" placeholder="<?= HtmlEncode($Page->apcid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->apcid->formatPattern()) ?>"<?= $Page->apcid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->apcid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="apc" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="3"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="apc"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="apc" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="apc" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cron->Visible) { // cron ?>
    <div id="r_cron" class="row"<?= $Page->cron->rowAttributes() ?>>
        <label for="x_cron" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_cron"><?= $Page->cron->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cron" id="z_cron" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cron->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_cron" class="ew-search-field ew-search-field-single">
    <select
        id="x_cron"
        name="x_cron"
        class="form-select ew-select<?= $Page->cron->isInvalidClass() ?>"
        <?php if (!$Page->cron->IsNativeSelect) { ?>
        data-select2-id="fapcsearch_x_cron"
        <?php } ?>
        data-table="apc"
        data-field="x_cron"
        data-value-separator="<?= $Page->cron->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cron->getPlaceHolder()) ?>"
        <?= $Page->cron->editAttributes() ?>>
        <?= $Page->cron->selectOptionListHtml("x_cron") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cron->getErrorMessage(false) ?></div>
<?php if (!$Page->cron->IsNativeSelect) { ?>
<script>
loadjs.ready("fapcsearch", function() {
    var options = { name: "x_cron", selectId: "fapcsearch_x_cron" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fapcsearch.lists.cron?.lookupOptions.length) {
        options.data = { id: "x_cron", form: "fapcsearch" };
    } else {
        options.ajax = { id: "x_cron", form: "fapcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.apc.fields.cron.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_cycle->Visible) { // next_cycle ?>
    <div id="r_next_cycle" class="row"<?= $Page->next_cycle->rowAttributes() ?>>
        <label for="x_next_cycle" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_next_cycle"><?= $Page->next_cycle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_cycle" id="z_next_cycle" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_cycle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_next_cycle" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->next_cycle->getInputTextType() ?>" name="x_next_cycle" id="x_next_cycle" data-table="apc" data-field="x_next_cycle" value="<?= $Page->next_cycle->EditValue ?>" placeholder="<?= HtmlEncode($Page->next_cycle->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->next_cycle->formatPattern()) ?>"<?= $Page->next_cycle->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->next_cycle->getErrorMessage(false) ?></div>
<?php if (!$Page->next_cycle->ReadOnly && !$Page->next_cycle->Disabled && !isset($Page->next_cycle->EditAttrs["readonly"]) && !isset($Page->next_cycle->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fapcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fapcsearch", "x_next_cycle", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delay->Visible) { // delay ?>
    <div id="r_delay" class="row"<?= $Page->delay->rowAttributes() ?>>
        <label for="x_delay" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_delay"><?= $Page->delay->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delay" id="z_delay" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delay->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_delay" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delay->getInputTextType() ?>" name="x_delay" id="x_delay" data-table="apc" data-field="x_delay" value="<?= $Page->delay->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->delay->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delay->formatPattern()) ?>"<?= $Page->delay->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delay->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delay_method->Visible) { // delay_method ?>
    <div id="r_delay_method" class="row"<?= $Page->delay_method->rowAttributes() ?>>
        <label for="x_delay_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_delay_method"><?= $Page->delay_method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delay_method" id="z_delay_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delay_method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_delay_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_delay_method"
        name="x_delay_method"
        class="form-select ew-select<?= $Page->delay_method->isInvalidClass() ?>"
        <?php if (!$Page->delay_method->IsNativeSelect) { ?>
        data-select2-id="fapcsearch_x_delay_method"
        <?php } ?>
        data-table="apc"
        data-field="x_delay_method"
        data-value-separator="<?= $Page->delay_method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delay_method->getPlaceHolder()) ?>"
        <?= $Page->delay_method->editAttributes() ?>>
        <?= $Page->delay_method->selectOptionListHtml("x_delay_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->delay_method->getErrorMessage(false) ?></div>
<?php if (!$Page->delay_method->IsNativeSelect) { ?>
<script>
loadjs.ready("fapcsearch", function() {
    var options = { name: "x_delay_method", selectId: "fapcsearch_x_delay_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fapcsearch.lists.delay_method?.lookupOptions.length) {
        options.data = { id: "x_delay_method", form: "fapcsearch" };
    } else {
        options.ajax = { id: "x_delay_method", form: "fapcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.apc.fields.delay_method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_updated->Visible) { // last_updated ?>
    <div id="r_last_updated" class="row"<?= $Page->last_updated->rowAttributes() ?>>
        <label for="x_last_updated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_last_updated"><?= $Page->last_updated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_last_updated" id="z_last_updated" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_updated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_last_updated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_updated->getInputTextType() ?>" name="x_last_updated" id="x_last_updated" data-table="apc" data-field="x_last_updated" value="<?= $Page->last_updated->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->last_updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_updated->formatPattern()) ?>"<?= $Page->last_updated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_updated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_level->Visible) { // user_level ?>
    <div id="r_user_level" class="row"<?= $Page->user_level->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_user_level"><?= $Page->user_level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_user_level" id="z_user_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_user_level" class="ew-search-field ew-search-field-single">
<template id="tp_x_user_level">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="apc" data-field="x_user_level" name="x_user_level" id="x_user_level"<?= $Page->user_level->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_user_level" class="ew-item-list"></div>
<selection-list hidden
    id="x_user_level[]"
    name="x_user_level[]"
    value="<?= HtmlEncode($Page->user_level->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_user_level"
    data-target="dsl_x_user_level"
    data-repeatcolumn="1"
    class="form-control<?= $Page->user_level->isInvalidClass() ?>"
    data-table="apc"
    data-field="x_user_level"
    data-value-separator="<?= $Page->user_level->displayValueSeparatorAttribute() ?>"
    <?= $Page->user_level->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->user_level->getErrorMessage(false) ?></div>
<?= $Page->user_level->Lookup->getParamTag($Page, "p_x_user_level") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
    <div id="r__visible" class="row"<?= $Page->_visible->rowAttributes() ?>>
        <label for="x__visible" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc__visible"><?= $Page->_visible->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__visible" id="z__visible" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_visible->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc__visible" class="ew-search-field ew-search-field-single">
    <select
        id="x__visible"
        name="x__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="fapcsearch_x__visible"
        <?php } ?>
        data-table="apc"
        data-field="x__visible"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x__visible") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage(false) ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("fapcsearch", function() {
    var options = { name: "x__visible", selectId: "fapcsearch_x__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fapcsearch.lists._visible?.lookupOptions.length) {
        options.data = { id: "x__visible", form: "fapcsearch" };
    } else {
        options.ajax = { id: "x__visible", form: "fapcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.apc.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fapcsearch_x_operator"
        <?php } ?>
        data-table="apc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fapcsearch", function() {
    var options = { name: "x_operator", selectId: "fapcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fapcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fapcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fapcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.apc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="apc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fapcsearch_x_status"
        <?php } ?>
        data-table="apc"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fapcsearch", function() {
    var options = { name: "x_status", selectId: "fapcsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fapcsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fapcsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fapcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.apc.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <div id="r_order_by" class="row"<?= $Page->order_by->rowAttributes() ?>>
        <label for="x_order_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_order_by"><?= $Page->order_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_by" id="z_order_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_order_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_by->getInputTextType() ?>" name="x_order_by" id="x_order_by" data-table="apc" data-field="x_order_by" value="<?= $Page->order_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_by->formatPattern()) ?>"<?= $Page->order_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_apc_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_apc_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="apc" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fapcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fapcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fapcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("apc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
