<?php

namespace PHPMaker2024\fibre;

// Page object
$AdminSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { admin: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fadminsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fadminsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["formal_name", [], fields.formal_name.isInvalid],
            ["_password", [], fields._password.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["pp_id", [], fields.pp_id.isInvalid],
            ["site", [], fields.site.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["_userlevel", [], fields._userlevel.isInvalid],
            ["activated", [], fields.activated.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["reg_ip", [], fields.reg_ip.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
            "site": <?= $Page->site->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "_userlevel": <?= $Page->_userlevel->toClientList($Page) ?>,
            "activated": <?= $Page->activated->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fadminsearch" id="fadminsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="admin">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="admin" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="admin" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name" class="row"<?= $Page->formal_name->rowAttributes() ?>>
        <label for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_formal_name"><?= $Page->formal_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->formal_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_formal_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="admin" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password" class="row"<?= $Page->_password->rowAttributes() ?>>
        <label for="x__password" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin__password"><?= $Page->_password->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__password" id="z__password" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_password->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin__password" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="admin" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name" class="row"<?= $Page->user_name->rowAttributes() ?>>
        <label for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_user_name"><?= $Page->user_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user_name" id="z_user_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_user_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="admin" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="admin" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x_category"
        <?php } ?>
        data-table="admin"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_category", selectId: "fadminsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="admin" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_company_id" class="ew-search-field">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fadminsearch_x_company_id"
        data-table="admin"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_company_id", selectId: "fadminsearch_x_company_id" };
    if (fadminsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.admin.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_company_id_1" name="v_company_id" value="AND"<?= ($Page->company_id->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_company_id_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_company_id_2" name="v_company_id" value="OR"<?= ($Page->company_id->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_company_id_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_company_id" id="w_company_id" value="=">
</span>
                    <span id="el2_admin_company_id" class="ew-search-field2">
    <select
        id="y_company_id"
        name="y_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fadminsearch_y_company_id"
        data-table="admin"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("y_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_y_company_id") ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "y_company_id", selectId: "fadminsearch_y_company_id" };
    if (fadminsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "y_company_id", form: "fadminsearch" };
    } else {
        options.ajax = { id: "y_company_id", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.admin.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id" class="row"<?= $Page->pp_id->rowAttributes() ?>>
        <label for="x_pp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_pp_id"><?= $Page->pp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_id" id="z_pp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_pp_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_pp_id"
        name="x_pp_id"
        class="form-select ew-select<?= $Page->pp_id->isInvalidClass() ?>"
        <?php if (!$Page->pp_id->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x_pp_id"
        <?php } ?>
        data-table="admin"
        data-field="x_pp_id"
        data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>"
        <?= $Page->pp_id->editAttributes() ?>>
        <?= $Page->pp_id->selectOptionListHtml("x_pp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage(false) ?></div>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
<?php if (!$Page->pp_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_pp_id", selectId: "fadminsearch_x_pp_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists.pp_id?.lookupOptions.length) {
        options.data = { id: "x_pp_id", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_pp_id", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.pp_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site" class="row"<?= $Page->site->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_site"><?= $Page->site->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_site" id="z_site" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->site->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_site" class="ew-search-field ew-search-field-single">
<template id="tp_x_site">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="admin" data-field="x_site" name="x_site" id="x_site"<?= $Page->site->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_site" class="ew-item-list"></div>
<selection-list hidden
    id="x_site[]"
    name="x_site[]"
    value="<?= HtmlEncode($Page->site->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_site"
    data-target="dsl_x_site"
    data-repeatcolumn="3"
    class="form-control<?= $Page->site->isInvalidClass() ?>"
    data-table="admin"
    data-field="x_site"
    data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
    <?= $Page->site->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->site->getErrorMessage(false) ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x_reports_to"
        <?php } ?>
        data-table="admin"
        data-field="x_reports_to"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_reports_to", selectId: "fadminsearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_userlevel->Visible) { // userlevel ?>
    <div id="r__userlevel" class="row"<?= $Page->_userlevel->rowAttributes() ?>>
        <label for="x__userlevel" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin__userlevel"><?= $Page->_userlevel->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__userlevel" id="z__userlevel" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_userlevel->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin__userlevel" class="ew-search-field ew-search-field-single">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span class="form-control-plaintext"><?= $Page->_userlevel->getDisplayValue($Page->_userlevel->EditValue) ?></span>
<?php } else { ?>
    <select
        id="x__userlevel"
        name="x__userlevel"
        class="form-select ew-select<?= $Page->_userlevel->isInvalidClass() ?>"
        <?php if (!$Page->_userlevel->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x__userlevel"
        <?php } ?>
        data-table="admin"
        data-field="x__userlevel"
        data-value-separator="<?= $Page->_userlevel->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userlevel->getPlaceHolder()) ?>"
        <?= $Page->_userlevel->editAttributes() ?>>
        <?= $Page->_userlevel->selectOptionListHtml("x__userlevel") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_userlevel->getErrorMessage(false) ?></div>
<?= $Page->_userlevel->Lookup->getParamTag($Page, "p_x__userlevel") ?>
<?php if (!$Page->_userlevel->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x__userlevel", selectId: "fadminsearch_x__userlevel" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists._userlevel?.lookupOptions.length) {
        options.data = { id: "x__userlevel", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x__userlevel", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields._userlevel.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->activated->Visible) { // activated ?>
    <div id="r_activated" class="row"<?= $Page->activated->rowAttributes() ?>>
        <label for="x_activated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_activated"><?= $Page->activated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_activated" id="z_activated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->activated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_activated" class="ew-search-field ew-search-field-single">
    <select
        id="x_activated"
        name="x_activated"
        class="form-select ew-select<?= $Page->activated->isInvalidClass() ?>"
        <?php if (!$Page->activated->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x_activated"
        <?php } ?>
        data-table="admin"
        data-field="x_activated"
        data-value-separator="<?= $Page->activated->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->activated->getPlaceHolder()) ?>"
        <?= $Page->activated->editAttributes() ?>>
        <?= $Page->activated->selectOptionListHtml("x_activated") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->activated->getErrorMessage(false) ?></div>
<?php if (!$Page->activated->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_activated", selectId: "fadminsearch_x_activated" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists.activated?.lookupOptions.length) {
        options.data = { id: "x_activated", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_activated", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.activated.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fadminsearch_x_operator"
        <?php } ?>
        data-table="admin"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminsearch", function() {
    var options = { name: "x_operator", selectId: "fadminsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fadminsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fadminsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="admin" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reg_ip->Visible) { // reg_ip ?>
    <div id="r_reg_ip" class="row"<?= $Page->reg_ip->rowAttributes() ?>>
        <label for="x_reg_ip" class="<?= $Page->LeftColumnClass ?>"><span id="elh_admin_reg_ip"><?= $Page->reg_ip->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reg_ip" id="z_reg_ip" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reg_ip->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_admin_reg_ip" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reg_ip->getInputTextType() ?>" name="x_reg_ip" id="x_reg_ip" data-table="admin" data-field="x_reg_ip" value="<?= $Page->reg_ip->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->reg_ip->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reg_ip->formatPattern()) ?>"<?= $Page->reg_ip->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reg_ip->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fadminsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fadminsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fadminsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("admin");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
