<?php

namespace PHPMaker2024\fibre;

// Page object
$AdminEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fadminedit" id="fadminedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { admin: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fadminedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fadminedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["_password", [fields._password.visible && fields._password.required ? ew.Validators.required(fields._password.caption) : null, ew.Validators.passwordStrength], fields._password.isInvalid],
            ["user_name", [fields.user_name.visible && fields.user_name.required ? ew.Validators.required(fields.user_name.caption) : null], fields.user_name.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["pp_id", [fields.pp_id.visible && fields.pp_id.required ? ew.Validators.required(fields.pp_id.caption) : null], fields.pp_id.isInvalid],
            ["site", [fields.site.visible && fields.site.required ? ew.Validators.required(fields.site.caption) : null], fields.site.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["_userlevel", [fields._userlevel.visible && fields._userlevel.required ? ew.Validators.required(fields._userlevel.caption) : null], fields._userlevel.isInvalid],
            ["activated", [fields.activated.visible && fields.activated.required ? ew.Validators.required(fields.activated.caption) : null], fields.activated.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["reg_ip", [fields.reg_ip.visible && fields.reg_ip.required ? ew.Validators.required(fields.reg_ip.caption) : null], fields.reg_ip.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
            "site": <?= $Page->site->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "_userlevel": <?= $Page->_userlevel->toClientList($Page) ?>,
            "activated": <?= $Page->activated->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="admin">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_admin_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_admin_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="admin" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_admin_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_admin_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="admin" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->formal_name->Visible) { // formal_name ?>
    <div id="r_formal_name"<?= $Page->formal_name->rowAttributes() ?>>
        <label id="elh_admin_formal_name" for="x_formal_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->formal_name->caption() ?><?= $Page->formal_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->formal_name->cellAttributes() ?>>
<span id="el_admin_formal_name">
<input type="<?= $Page->formal_name->getInputTextType() ?>" name="x_formal_name" id="x_formal_name" data-table="admin" data-field="x_formal_name" value="<?= $Page->formal_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->formal_name->formatPattern()) ?>"<?= $Page->formal_name->editAttributes() ?> aria-describedby="x_formal_name_help">
<?= $Page->formal_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->formal_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password"<?= $Page->_password->rowAttributes() ?>>
        <label id="elh_admin__password" for="x__password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_password->caption() ?><?= $Page->_password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_password->cellAttributes() ?>>
<span id="el_admin__password">
<div class="input-group" id="ig__password">
    <input type="password" autocomplete="new-password" data-password-strength="pst__password" data-table="admin" data-field="x__password" name="x__password" id="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>"<?= $Page->_password->editAttributes() ?> aria-describedby="x__password_help">
    <button type="button" class="btn btn-default ew-toggle-password" data-ew-action="password"><i class="fa-solid fa-eye"></i></button>
    <button type="button" class="btn btn-default ew-password-generator rounded-end" title="<?= HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x__password" data-password-confirm="c__password" data-password-strength="pst__password"><?= $Language->phrase("GeneratePassword") ?></button>
</div>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst__password" role="progressbar">
    <div class="progress-bar"></div>
</div>
<?= $Page->_password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name"<?= $Page->user_name->rowAttributes() ?>>
        <label id="elh_admin_user_name" for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->user_name->caption() ?><?= $Page->user_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->user_name->cellAttributes() ?>>
<span id="el_admin_user_name">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="admin" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?> aria-describedby="x_user_name_help">
<?= $Page->user_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_admin_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_admin_address">
<textarea data-table="admin" data-field="x_address" name="x_address" id="x_address" cols="30" rows="3" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_admin_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_admin_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x_category"
        <?php } ?>
        data-table="admin"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_category", selectId: "fadminedit_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_category", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_admin__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_admin__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="admin" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_admin_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_admin_company_id">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fadminedit_x_company_id"
        data-table="admin"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?= $Page->company_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_company_id", selectId: "fadminedit_x_company_id" };
    if (fadminedit.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_company_id", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.admin.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id"<?= $Page->pp_id->rowAttributes() ?>>
        <label id="elh_admin_pp_id" for="x_pp_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pp_id->caption() ?><?= $Page->pp_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pp_id->cellAttributes() ?>>
<span id="el_admin_pp_id">
    <select
        id="x_pp_id"
        name="x_pp_id"
        class="form-select ew-select<?= $Page->pp_id->isInvalidClass() ?>"
        <?php if (!$Page->pp_id->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x_pp_id"
        <?php } ?>
        data-table="admin"
        data-field="x_pp_id"
        data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>"
        <?= $Page->pp_id->editAttributes() ?>>
        <?= $Page->pp_id->selectOptionListHtml("x_pp_id") ?>
    </select>
    <?= $Page->pp_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage() ?></div>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
<?php if (!$Page->pp_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_pp_id", selectId: "fadminedit_x_pp_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists.pp_id?.lookupOptions.length) {
        options.data = { id: "x_pp_id", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_pp_id", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.pp_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site"<?= $Page->site->rowAttributes() ?>>
        <label id="elh_admin_site" class="<?= $Page->LeftColumnClass ?>"><?= $Page->site->caption() ?><?= $Page->site->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->site->cellAttributes() ?>>
<span id="el_admin_site">
<template id="tp_x_site">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="admin" data-field="x_site" name="x_site" id="x_site"<?= $Page->site->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_site" class="ew-item-list"></div>
<selection-list hidden
    id="x_site[]"
    name="x_site[]"
    value="<?= HtmlEncode($Page->site->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_site"
    data-target="dsl_x_site"
    data-repeatcolumn="3"
    class="form-control<?= $Page->site->isInvalidClass() ?>"
    data-table="admin"
    data-field="x_site"
    data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
    <?= $Page->site->editAttributes() ?>></selection-list>
<?= $Page->site->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->site->getErrorMessage() ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to"<?= $Page->reports_to->rowAttributes() ?>>
        <label id="elh_admin_reports_to" for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reports_to->caption() ?><?= $Page->reports_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reports_to->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<?php if (SameString($Page->id->CurrentValue, CurrentUserID())) { ?>
    <span<?= $Page->reports_to->viewAttributes() ?>>
    <span class="form-control-plaintext"><?= $Page->reports_to->getDisplayValue($Page->reports_to->EditValue) ?></span></span>
    <input type="hidden" data-table="admin" data-field="x_reports_to" data-hidden="1" name="x_reports_to" id="x_reports_to" value="<?= HtmlEncode($Page->reports_to->CurrentValue) ?>">
<?php } else { ?>
<span id="el_admin_reports_to">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x_reports_to"
        <?php } ?>
        data-table="admin"
        data-field="x_reports_to"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <?= $Page->reports_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage() ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_reports_to", selectId: "fadminedit_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el_admin_reports_to">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x_reports_to"
        <?php } ?>
        data-table="admin"
        data-field="x_reports_to"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <?= $Page->reports_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage() ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_reports_to", selectId: "fadminedit_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_userlevel->Visible) { // userlevel ?>
    <div id="r__userlevel"<?= $Page->_userlevel->rowAttributes() ?>>
        <label id="elh_admin__userlevel" for="x__userlevel" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_userlevel->caption() ?><?= $Page->_userlevel->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_userlevel->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span id="el_admin__userlevel">
<span class="form-control-plaintext"><?= $Page->_userlevel->getDisplayValue($Page->_userlevel->EditValue) ?></span>
</span>
<?php } else { ?>
<span id="el_admin__userlevel">
    <select
        id="x__userlevel"
        name="x__userlevel"
        class="form-select ew-select<?= $Page->_userlevel->isInvalidClass() ?>"
        <?php if (!$Page->_userlevel->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x__userlevel"
        <?php } ?>
        data-table="admin"
        data-field="x__userlevel"
        data-value-separator="<?= $Page->_userlevel->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_userlevel->getPlaceHolder()) ?>"
        <?= $Page->_userlevel->editAttributes() ?>>
        <?= $Page->_userlevel->selectOptionListHtml("x__userlevel") ?>
    </select>
    <?= $Page->_userlevel->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_userlevel->getErrorMessage() ?></div>
<?= $Page->_userlevel->Lookup->getParamTag($Page, "p_x__userlevel") ?>
<?php if (!$Page->_userlevel->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x__userlevel", selectId: "fadminedit_x__userlevel" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists._userlevel?.lookupOptions.length) {
        options.data = { id: "x__userlevel", form: "fadminedit" };
    } else {
        options.ajax = { id: "x__userlevel", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields._userlevel.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->activated->Visible) { // activated ?>
    <div id="r_activated"<?= $Page->activated->rowAttributes() ?>>
        <label id="elh_admin_activated" for="x_activated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->activated->caption() ?><?= $Page->activated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->activated->cellAttributes() ?>>
<span id="el_admin_activated">
    <select
        id="x_activated"
        name="x_activated"
        class="form-select ew-select<?= $Page->activated->isInvalidClass() ?>"
        <?php if (!$Page->activated->IsNativeSelect) { ?>
        data-select2-id="fadminedit_x_activated"
        <?php } ?>
        data-table="admin"
        data-field="x_activated"
        data-value-separator="<?= $Page->activated->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->activated->getPlaceHolder()) ?>"
        <?= $Page->activated->editAttributes() ?>>
        <?= $Page->activated->selectOptionListHtml("x_activated") ?>
    </select>
    <?= $Page->activated->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->activated->getErrorMessage() ?></div>
<?php if (!$Page->activated->IsNativeSelect) { ?>
<script>
loadjs.ready("fadminedit", function() {
    var options = { name: "x_activated", selectId: "fadminedit_x_activated" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fadminedit.lists.activated?.lookupOptions.length) {
        options.data = { id: "x_activated", form: "fadminedit" };
    } else {
        options.ajax = { id: "x_activated", form: "fadminedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.admin.fields.activated.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fadminedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fadminedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("admin");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
