<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("AccountInfoGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var faccount_infogrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { account_info: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("faccount_infogrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["balance", [fields.balance.visible && fields.balance.required ? ew.Validators.required(fields.balance.caption) : null, ew.Validators.float], fields.balance.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["type",false],["formal_name",false],["balance",false],["reference",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Grid->type->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="faccount_infogrid" class="ew-form ew-list-form">
<div id="gmp_account_info" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_account_infogrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_account_info_id" class="account_info_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Grid->type->headerCellClass() ?>"><div id="elh_account_info_type" class="account_info_type"><?= $Grid->renderFieldHeader($Grid->type) ?></div></th>
<?php } ?>
<?php if ($Grid->formal_name->Visible) { // formal_name ?>
        <th data-name="formal_name" class="<?= $Grid->formal_name->headerCellClass() ?>"><div id="elh_account_info_formal_name" class="account_info_formal_name"><?= $Grid->renderFieldHeader($Grid->formal_name) ?></div></th>
<?php } ?>
<?php if ($Grid->balance->Visible) { // balance ?>
        <th data-name="balance" class="<?= $Grid->balance->headerCellClass() ?>"><div id="elh_account_info_balance" class="account_info_balance"><?= $Grid->renderFieldHeader($Grid->balance) ?></div></th>
<?php } ?>
<?php if ($Grid->reference->Visible) { // reference ?>
        <th data-name="reference" class="<?= $Grid->reference->headerCellClass() ?>"><div id="elh_account_info_reference" class="account_info_reference"><?= $Grid->renderFieldHeader($Grid->reference) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_account_info_status" class="account_info_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_id" class="el_account_info_id"></span>
<input type="hidden" data-table="account_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_id" class="el_account_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="account_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_id" class="el_account_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_id" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_id" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_id" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_id" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="account_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->type->Visible) { // type ?>
        <td data-name="type"<?= $Grid->type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_type" class="el_account_info_type">
    <select
        id="x<?= $Grid->RowIndex ?>_type"
        name="x<?= $Grid->RowIndex ?>_type"
        class="form-select ew-select<?= $Grid->type->isInvalidClass() ?>"
        <?php if (!$Grid->type->IsNativeSelect) { ?>
        data-select2-id="faccount_infogrid_x<?= $Grid->RowIndex ?>_type"
        <?php } ?>
        data-table="account_info"
        data-field="x_type"
        data-value-separator="<?= $Grid->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->type->getPlaceHolder()) ?>"
        <?= $Grid->type->editAttributes() ?>>
        <?= $Grid->type->selectOptionListHtml("x{$Grid->RowIndex}_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->type->getErrorMessage() ?></div>
<?= $Grid->type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_type") ?>
<?php if (!$Grid->type->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_type", selectId: "faccount_infogrid_x<?= $Grid->RowIndex ?>_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_infogrid.lists.type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_type", form: "faccount_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_type", form: "faccount_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="account_info" data-field="x_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_type" id="o<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_type" class="el_account_info_type">
    <select
        id="x<?= $Grid->RowIndex ?>_type"
        name="x<?= $Grid->RowIndex ?>_type"
        class="form-select ew-select<?= $Grid->type->isInvalidClass() ?>"
        <?php if (!$Grid->type->IsNativeSelect) { ?>
        data-select2-id="faccount_infogrid_x<?= $Grid->RowIndex ?>_type"
        <?php } ?>
        data-table="account_info"
        data-field="x_type"
        data-value-separator="<?= $Grid->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->type->getPlaceHolder()) ?>"
        <?= $Grid->type->editAttributes() ?>>
        <?= $Grid->type->selectOptionListHtml("x{$Grid->RowIndex}_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->type->getErrorMessage() ?></div>
<?= $Grid->type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_type") ?>
<?php if (!$Grid->type->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_type", selectId: "faccount_infogrid_x<?= $Grid->RowIndex ?>_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_infogrid.lists.type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_type", form: "faccount_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_type", form: "faccount_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_info.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_type" class="el_account_info_type">
<span<?= $Grid->type->viewAttributes() ?>>
<?= $Grid->type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_type" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_type" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_type" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_type" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->formal_name->Visible) { // formal_name ?>
        <td data-name="formal_name"<?= $Grid->formal_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_formal_name" class="el_account_info_formal_name">
<input type="<?= $Grid->formal_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_formal_name" id="x<?= $Grid->RowIndex ?>_formal_name" data-table="account_info" data-field="x_formal_name" value="<?= $Grid->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->formal_name->formatPattern()) ?>"<?= $Grid->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->formal_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_info" data-field="x_formal_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_formal_name" id="o<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_formal_name" class="el_account_info_formal_name">
<input type="<?= $Grid->formal_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_formal_name" id="x<?= $Grid->RowIndex ?>_formal_name" data-table="account_info" data-field="x_formal_name" value="<?= $Grid->formal_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->formal_name->formatPattern()) ?>"<?= $Grid->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->formal_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_formal_name" class="el_account_info_formal_name">
<span<?= $Grid->formal_name->viewAttributes() ?>>
<?= $Grid->formal_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_formal_name" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_formal_name" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_formal_name" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_formal_name" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->balance->Visible) { // balance ?>
        <td data-name="balance"<?= $Grid->balance->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_balance" class="el_account_info_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="account_info" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_info" data-field="x_balance" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_balance" id="o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_balance" class="el_account_info_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="account_info" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_balance" class="el_account_info_balance">
<span<?= $Grid->balance->viewAttributes() ?>>
<?= $Grid->balance->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_balance" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_balance" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_balance" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_balance" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->reference->Visible) { // reference ?>
        <td data-name="reference"<?= $Grid->reference->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_reference" class="el_account_info_reference">
<input type="<?= $Grid->reference->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" data-table="account_info" data-field="x_reference" value="<?= $Grid->reference->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->reference->formatPattern()) ?>"<?= $Grid->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->reference->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_info" data-field="x_reference" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_reference" id="o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_reference" class="el_account_info_reference">
<span<?= $Grid->reference->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->reference->getDisplayValue($Grid->reference->EditValue))) ?>"></span>
<input type="hidden" data-table="account_info" data-field="x_reference" data-hidden="1" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_reference" class="el_account_info_reference">
<span<?= $Grid->reference->viewAttributes() ?>>
<?= $Grid->reference->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_reference" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_reference" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_reference" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_reference" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_status" class="el_account_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="faccount_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="account_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "faccount_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="account_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_status" class="el_account_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="faccount_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="account_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "faccount_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_info_status" class="el_account_info_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_info" data-field="x_status" data-hidden="1" name="faccount_infogrid$x<?= $Grid->RowIndex ?>_status" id="faccount_infogrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="account_info" data-field="x_status" data-hidden="1" data-old name="faccount_infogrid$o<?= $Grid->RowIndex ?>_status" id="faccount_infogrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["faccount_infogrid","load"], () => faccount_infogrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="faccount_infogrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("account_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
