<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("AccountGrpGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var faccount_grpgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { account_grp: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("faccount_grpgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id_s", [fields.id_s.visible && fields.id_s.required ? ew.Validators.required(fields.id_s.caption) : null], fields.id_s.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["balance", [fields.balance.visible && fields.balance.required ? ew.Validators.required(fields.balance.caption) : null, ew.Validators.float], fields.balance.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["id_s",false],["item",false],["balance",false],["grp",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="faccount_grpgrid" class="ew-form ew-list-form">
<div id="gmp_account_grp" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_account_grpgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id_s->Visible) { // id_s ?>
        <th data-name="id_s" class="<?= $Grid->id_s->headerCellClass() ?>"><div id="elh_account_grp_id_s" class="account_grp_id_s"><?= $Grid->renderFieldHeader($Grid->id_s) ?></div></th>
<?php } ?>
<?php if ($Grid->item->Visible) { // item ?>
        <th data-name="item" class="<?= $Grid->item->headerCellClass() ?>"><div id="elh_account_grp_item" class="account_grp_item"><?= $Grid->renderFieldHeader($Grid->item) ?></div></th>
<?php } ?>
<?php if ($Grid->balance->Visible) { // balance ?>
        <th data-name="balance" class="<?= $Grid->balance->headerCellClass() ?>"><div id="elh_account_grp_balance" class="account_grp_balance"><?= $Grid->renderFieldHeader($Grid->balance) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_account_grp_grp" class="account_grp_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_account_grp_status" class="account_grp_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_account_grp_operator" class="account_grp_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_account_grp_datetime" class="account_grp_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id_s->Visible) { // id_s ?>
        <td data-name="id_s"<?= $Grid->id_s->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_id_s" class="el_account_grp_id_s">
<input type="<?= $Grid->id_s->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id_s" id="x<?= $Grid->RowIndex ?>_id_s" data-table="account_grp" data-field="x_id_s" value="<?= $Grid->id_s->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->id_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id_s->formatPattern()) ?>"<?= $Grid->id_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id_s->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_grp" data-field="x_id_s" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id_s" id="o<?= $Grid->RowIndex ?>_id_s" value="<?= HtmlEncode($Grid->id_s->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_id_s" class="el_account_grp_id_s">
<input type="<?= $Grid->id_s->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id_s" id="x<?= $Grid->RowIndex ?>_id_s" data-table="account_grp" data-field="x_id_s" value="<?= $Grid->id_s->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->id_s->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id_s->formatPattern()) ?>"<?= $Grid->id_s->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id_s->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_id_s" class="el_account_grp_id_s">
<span<?= $Grid->id_s->viewAttributes() ?>>
<?= $Grid->id_s->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_id_s" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_id_s" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_id_s" value="<?= HtmlEncode($Grid->id_s->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_id_s" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_id_s" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_id_s" value="<?= HtmlEncode($Grid->id_s->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->item->Visible) { // item ?>
        <td data-name="item"<?= $Grid->item->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_item" class="el_account_grp_item">
<input type="<?= $Grid->item->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_item" id="x<?= $Grid->RowIndex ?>_item" data-table="account_grp" data-field="x_item" value="<?= $Grid->item->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->item->formatPattern()) ?>"<?= $Grid->item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->item->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_grp" data-field="x_item" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_item" id="o<?= $Grid->RowIndex ?>_item" value="<?= HtmlEncode($Grid->item->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_item" class="el_account_grp_item">
<input type="<?= $Grid->item->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_item" id="x<?= $Grid->RowIndex ?>_item" data-table="account_grp" data-field="x_item" value="<?= $Grid->item->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->item->formatPattern()) ?>"<?= $Grid->item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->item->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_item" class="el_account_grp_item">
<span<?= $Grid->item->viewAttributes() ?>>
<?= $Grid->item->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_item" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_item" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_item" value="<?= HtmlEncode($Grid->item->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_item" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_item" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_item" value="<?= HtmlEncode($Grid->item->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->balance->Visible) { // balance ?>
        <td data-name="balance"<?= $Grid->balance->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_balance" class="el_account_grp_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="account_grp" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="account_grp" data-field="x_balance" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_balance" id="o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_balance" class="el_account_grp_balance">
<input type="<?= $Grid->balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_balance" id="x<?= $Grid->RowIndex ?>_balance" data-table="account_grp" data-field="x_balance" value="<?= $Grid->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->balance->formatPattern()) ?>"<?= $Grid->balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->balance->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_balance" class="el_account_grp_balance">
<span<?= $Grid->balance->viewAttributes() ?>>
<?= $Grid->balance->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_balance" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_balance" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_balance" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_balance" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_balance" value="<?= HtmlEncode($Grid->balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->grp->getSessionValue() != "") { ?>
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->ViewValue) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_grp" name="x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_grp" class="el_account_grp_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="faccount_grpgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="account_grp"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_grpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "faccount_grpgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_grpgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "faccount_grpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "faccount_grpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_grp.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="account_grp" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->grp->getSessionValue() != "") { ?>
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->ViewValue) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->ViewValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->ViewValue) ?></span>
<?php } ?>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_grp" name="x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_grp" class="el_account_grp_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="faccount_grpgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="account_grp"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_grpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "faccount_grpgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_grpgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "faccount_grpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "faccount_grpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_grp.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_grp" class="el_account_grp_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_grp" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_grp" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_grp" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_grp" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_status" class="el_account_grp_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="faccount_grpgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="account_grp"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_grpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "faccount_grpgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_grpgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_grpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_grpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_grp.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="account_grp" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_status" class="el_account_grp_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="faccount_grpgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="account_grp"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("faccount_grpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "faccount_grpgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (faccount_grpgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_grpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "faccount_grpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.account_grp.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_status" class="el_account_grp_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_status" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_status" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_status" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_status" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="account_grp" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_operator" class="el_account_grp_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_operator" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_operator" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_operator" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_operator" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="account_grp" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_account_grp_datetime" class="el_account_grp_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="account_grp" data-field="x_datetime" data-hidden="1" name="faccount_grpgrid$x<?= $Grid->RowIndex ?>_datetime" id="faccount_grpgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="account_grp" data-field="x_datetime" data-hidden="1" data-old name="faccount_grpgrid$o<?= $Grid->RowIndex ?>_datetime" id="faccount_grpgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["faccount_grpgrid","load"], () => faccount_grpgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="faccount_grpgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("account_grp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
