<?php

namespace PHPMaker2024\fibre;

use Slim\Views\PhpRenderer;
use Slim\Csrf\Guard;
use Slim\HttpCache\CacheProvider;
use Slim\Flash\Messages;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Doctrine\DBAL\Logging\LoggerChain;
use Doctrine\DBAL\Logging\DebugStack;
use Doctrine\DBAL\Platforms;
use Doctrine\Common\Cache\Psr6\DoctrineProvider;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\Events;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Mime\MimeTypes;
use FastRoute\RouteParser\Std;
use Illuminate\Encryption\Encrypter;
use HTMLPurifier_Config;
use HTMLPurifier;

// Connections and entity managers
$definitions = [];
$dbids = array_keys(Config("Databases"));
foreach ($dbids as $dbid) {
    $definitions["connection." . $dbid] = \DI\factory(function (string $dbid) {
        return ConnectDb(Db($dbid));
    })->parameter("dbid", $dbid);
    $definitions["entitymanager." . $dbid] = \DI\factory(function (ContainerInterface $c, string $dbid) {
        $cache = IsDevelopment()
            ? DoctrineProvider::wrap(new ArrayAdapter())
            : DoctrineProvider::wrap(new FilesystemAdapter(directory: Config("DOCTRINE.CACHE_DIR")));
        $config = Setup::createAttributeMetadataConfiguration(
            Config("DOCTRINE.METADATA_DIRS"),
            IsDevelopment(),
            null,
            $cache
        );
        $conn = $c->get("connection." . $dbid);
        return new EntityManager($conn, $config);
    })->parameter("dbid", $dbid);
}

return [
    "app.cache" => \DI\create(CacheProvider::class),
    "app.flash" => fn(ContainerInterface $c) => new Messages(),
    "app.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "views/"),
    "email.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "lang/"),
    "sms.view" => fn(ContainerInterface $c) => new PhpRenderer($GLOBALS["RELATIVE_PATH"] . "lang/"),
    "app.audit" => fn(ContainerInterface $c) => (new Logger("audit"))->pushHandler(new AuditTrailHandler($GLOBALS["RELATIVE_PATH"] . "log/audit.log")), // For audit trail
    "app.logger" => fn(ContainerInterface $c) => (new Logger("log"))->pushHandler(new RotatingFileHandler($GLOBALS["RELATIVE_PATH"] . "log/log.log")),
    "sql.logger" => function (ContainerInterface $c) {
        $loggers = [];
        if (Config("DEBUG")) {
            $loggers[] = $c->get("debug.stack");
        }
        return (count($loggers) > 0) ? new LoggerChain($loggers) : null;
    },
    "app.csrf" => fn(ContainerInterface $c) => new Guard($GLOBALS["ResponseFactory"], Config("CSRF_PREFIX")),
    "html.purifier.config" => fn(ContainerInterface $c) => HTMLPurifier_Config::createDefault(),
    "html.purifier" => fn(ContainerInterface $c) => new HTMLPurifier($c->get("html.purifier.config")),
    "debug.stack" => \DI\create(DebugStack::class),
    "debug.sql.logger" => \DI\create(DebugSqlLogger::class),
    "debug.timer" => \DI\create(Timer::class),
    "app.security" => \DI\create(AdvancedSecurity::class),
    "user.profile" => \DI\create(UserProfile::class),
    "app.session" => \DI\create(HttpSession::class),
    "mime.types" => \DI\create(MimeTypes::class),
    "app.language" => \DI\create(Language::class),
    PermissionMiddleware::class => \DI\create(PermissionMiddleware::class),
    ApiPermissionMiddleware::class => \DI\create(ApiPermissionMiddleware::class),
    JwtMiddleware::class => \DI\create(JwtMiddleware::class),
    Std::class => \DI\create(Std::class),
    Encrypter::class => fn(ContainerInterface $c) => new Encrypter(AesEncryptionKey(base64_decode(Config("AES_ENCRYPTION_KEY"))), Config("AES_ENCRYPTION_CIPHER")),

    // Tables
    "account_grp" => \DI\create(AccountGrp::class),
    "account_info" => \DI\create(AccountInfo::class),
    "account_type" => \DI\create(AccountType::class),
    "add_optional" => \DI\create(AddOptional::class),
    "admin" => \DI\create(Admin::class),
    "admin_category" => \DI\create(AdminCategory::class),
    "admin_office" => \DI\create(AdminOffice::class),
    "agent" => \DI\create(Agent::class),
    "apc" => \DI\create(Apc::class),
    "apc_pfv" => \DI\create(ApcPfv::class),
    "apcajax" => \DI\create(Apcajax::class),
    "apcajax_2" => \DI\create(Apcajax2::class),
    "apcajax_fm" => \DI\create(ApcajaxFm::class),
    "apcajax_fs" => \DI\create(ApcajaxFs::class),
    "apcajax_s" => \DI\create(ApcajaxS::class),
    "apcajax_tc" => \DI\create(ApcajaxTc::class),
    "apcajaxes" => \DI\create(Apcajaxes::class),
    "app2" => \DI\create(App2::class),
    "assign_process" => \DI\create(AssignProcess::class),
    "assign_production" => \DI\create(AssignProduction::class),
    "assignimage" => \DI\create(Assignimage::class),
    "audittrail" => \DI\create(Audittrail::class),
    "audittrail_l" => \DI\create(AudittrailL::class),
    "audittrail_u" => \DI\create(AudittrailU::class),
    "auto_programme2" => \DI\create(AutoProgramme2::class),
    "autoprogramme" => \DI\create(Autoprogramme::class),
    "autoprogrammenhf" => \DI\create(Autoprogrammenhf::class),
    "b_account_compiled" => \DI\create(BAccountCompiled::class),
    "b_account_info" => \DI\create(BAccountInfo::class),
    "b_account_info_agent" => \DI\create(BAccountInfoAgent::class),
    "b_account_int_log" => \DI\create(BAccountIntLog::class),
    "b_account_int_log_tmp" => \DI\create(BAccountIntLogTmp::class),
    "b_account_type" => \DI\create(BAccountType::class),
    "b_charges_plan" => \DI\create(BChargesPlan::class),
    "b_incentive" => \DI\create(BIncentive::class),
    "b_incentive_pp" => \DI\create(BIncentivePp::class),
    "b_status" => \DI\create(BStatus::class),
    "b_status_view2" => \DI\create(BStatusView2::class),
    "balance" => \DI\create(Balance::class),
    "balance_detailed" => \DI\create(BalanceDetailed::class),
    "bank" => \DI\create(Bank::class),
    "bank_info" => \DI\create(BankInfo::class),
    "banner" => \DI\create(Banner::class),
    "barcode2" => \DI\create(Barcode2::class),
    "barcode_in_process" => \DI\create(BarcodeInProcess::class),
    "barcode_print" => \DI\create(BarcodePrint::class),
    "barcode_query" => \DI\create(BarcodeQuery::class),
    "barcode_search" => \DI\create(BarcodeSearch::class),
    "batch_no" => \DI\create(BatchNo::class),
    "bcode" => \DI\create(Bcode::class),
    "bcode_old" => \DI\create(BcodeOld::class),
    "bcode_p_remarks" => \DI\create(BcodePRemarks::class),
    "bcode_s" => \DI\create(BcodeS::class),
    "bcode_token" => \DI\create(BcodeToken::class),
    "blending_process_f" => \DI\create(BlendingProcessF::class),
    "blending_table" => \DI\create(BlendingTable::class),
    "bom" => \DI\create(Bom::class),
    "booking" => \DI\create(Booking::class),
    "booking_confirm" => \DI\create(BookingConfirm::class),
    "booking_details" => \DI\create(BookingDetails::class),
    "booking_ref" => \DI\create(BookingRef::class),
    "buyer" => \DI\create(Buyer::class),
    "buyer_product_ref_g" => \DI\create(BuyerProductRefG::class),
    "buyer_sales" => \DI\create(BuyerSales::class),
    "buyer_seller_employee" => \DI\create(BuyerSellerEmployee::class),
    "buyer_seller_view" => \DI\create(BuyerSellerView::class),
    "bwfpbgvy" => \DI\create(Bwfpbgvy::class),
    "byproduct_comparison" => \DI\create(ByproductComparison::class),
    "c_charge" => \DI\create(CCharge::class),
    "calendar" => \DI\create(Calendar::class),
    "calendar_deleted" => \DI\create(CalendarDeleted::class),
    "calendar_routine_task" => \DI\create(CalendarRoutineTask::class),
    "capacity_plan" => \DI\create(CapacityPlan::class),
    "carpet_setup" => \DI\create(CarpetSetup::class),
    "cart_b_live" => \DI\create(CartBLive::class),
    "cha_agent" => \DI\create(ChaAgent::class),
    "check_security" => \DI\create(CheckSecurity::class),
    "client_category" => \DI\create(ClientCategory::class),
    "client_db" => \DI\create(ClientDb::class),
    "client_hardware_data" => \DI\create(ClientHardwareData::class),
    "code_exchange" => \DI\create(CodeExchange::class),
    "collection_log" => \DI\create(CollectionLog::class),
    "complete_process" => \DI\create(CompleteProcess::class),
    "composition" => \DI\create(Composition::class),
    "cost_calculator" => \DI\create(CostCalculator::class),
    "cost_calculator_detailed" => \DI\create(CostCalculatorDetailed::class),
    "csv_import" => \DI\create(CsvImport::class),
    "currency" => \DI\create(Currency::class),
    "customized_message" => \DI\create(CustomizedMessage::class),
    "d_05" => \DI\create(D05::class),
    "d_b_view" => \DI\create(DBView::class),
    "dashboard2" => \DI\create(Dashboard2::class),
    "Day_Planner" => \DI\create(DayPlanner::class),
    "day_planner" => \DI\create(DayPlanner::class),
    "db2" => \DI\create(Db2::class),
    "description" => \DI\create(Description::class),
    "dispatch_week_plan" => \DI\create(DispatchWeekPlan::class),
    "download" => \DI\create(Download::class),
    "dummy" => \DI\create(Dummy::class),
    "emi_calculator" => \DI\create(EmiCalculator::class),
    "employee_card" => \DI\create(EmployeeCard::class),
    "exportlog" => \DI\create(Exportlog::class),
    "family_event_estimate" => \DI\create(FamilyEventEstimate::class),
    "family_event_list" => \DI\create(FamilyEventList::class),
    "family_info" => \DI\create(FamilyInfo::class),
    "family_misc" => \DI\create(FamilyMisc::class),
    "fe_setup" => \DI\create(FeSetup::class),
    "gallery" => \DI\create(Gallery::class),
    "gallery_misc" => \DI\create(GalleryMisc::class),
    "gate_pass" => \DI\create(GatePass::class),
    "gate_pass_print_hsc_fp" => \DI\create(GatePassPrintHscFp::class),
    "gate_pass_received" => \DI\create(GatePassReceived::class),
    "godown" => \DI\create(Godown::class),
    "godown_table" => \DI\create(GodownTable::class),
    "godown_transfer_hs" => \DI\create(GodownTransferHs::class),
    "godown_transfer_new" => \DI\create(GodownTransferNew::class),
    "godown_transfer_table" => \DI\create(GodownTransferTable::class),
    "grp" => \DI\create(Grp::class),
    "gst_challan" => \DI\create(GstChallan::class),
    "gst_challan_extra" => \DI\create(GstChallanExtra::class),
    "gst_challan_f" => \DI\create(GstChallanF::class),
    "gst_challan_g" => \DI\create(GstChallanG::class),
    "help" => \DI\create(Help::class),
    "home" => \DI\create(Home::class),
    "import_bcode" => \DI\create(ImportBcode::class),
    "import_csv" => \DI\create(ImportCsv::class),
    "import_file" => \DI\create(ImportFile::class),
    "importer" => \DI\create(Importer::class),
    "incoterm" => \DI\create(Incoterm::class),
    "int_fibre_account_grp" => \DI\create(IntFibreAccountGrp::class),
    "int_fibre_apc_grp" => \DI\create(IntFibreApcGrp::class),
    "int_fibre_help" => \DI\create(IntFibreHelp::class),
    "int_fibre_packing_type" => \DI\create(IntFibrePackingType::class),
    "int_portal_list" => \DI\create(IntPortalList::class),
    "int_portal_updates" => \DI\create(IntPortalUpdates::class),
    "int_shop" => \DI\create(IntShop::class),
    "investor_info" => \DI\create(InvestorInfo::class),
    "investor_list" => \DI\create(InvestorList::class),
    "invoice_details" => \DI\create(InvoiceDetails::class),
    "jc_mrlot" => \DI\create(JcMrlot::class),
    "job_card" => \DI\create(JobCard::class),
    "job_card_bc" => \DI\create(JobCardBc::class),
    "job_card_bc_old" => \DI\create(JobCardBcOld::class),
    "job_card_description" => \DI\create(JobCardDescription::class),
    "job_card_f" => \DI\create(JobCardF::class),
    "job_card_hs" => \DI\create(JobCardHs::class),
    "job_card_pending_query" => \DI\create(JobCardPendingQuery::class),
    "journal" => \DI\create(Journal::class),
    "KiogQ3JvbiBNYWlsZXIgLyBBUEMgLyBPdGhlcg" => \DI\create(KiogQ3JvbiBnyWlsZxIgLyBbueMgLyBPdGhlcg::class),
    "kiogq3jvbibnywlszxiglybbuemglybpdghlcg" => \DI\create(KiogQ3JvbiBnyWlsZxIgLyBbueMgLyBPdGhlcg::class),
    "l_examination" => \DI\create(LExamination::class),
    "l_examination_report" => \DI\create(LExaminationReport::class),
    "l_examination_type" => \DI\create(LExaminationType::class),
    "l_pending_examination" => \DI\create(LPendingExamination::class),
    "l_receipt" => \DI\create(LReceipt::class),
    "l_referral" => \DI\create(LReferral::class),
    "ledger" => \DI\create(Ledger::class),
    "locations" => \DI\create(Locations::class),
    "loginip" => \DI\create(Loginip::class),
    "loom_info" => \DI\create(LoomInfo::class),
    "lot_no_details" => \DI\create(LotNoDetails::class),
    "mail_record" => \DI\create(MailRecord::class),
    "mail_setup" => \DI\create(MailSetup::class),
    "mailer_cron" => \DI\create(MailerCron::class),
    "mailer_view" => \DI\create(MailerView::class),
    "margin_list" => \DI\create(MarginList::class),
    "margin_list_monthly" => \DI\create(MarginListMonthly::class),
    "material_order" => \DI\create(MaterialOrder::class),
    "material_out" => \DI\create(MaterialOut::class),
    "material_out_bc" => \DI\create(MaterialOutBc::class),
    "material_out_old" => \DI\create(MaterialOutOld::class),
    "material_out_po" => \DI\create(MaterialOutPo::class),
    "material_out_wbc" => \DI\create(MaterialOutWbc::class),
    "material_required" => \DI\create(MaterialRequired::class),
    "material_required_export" => \DI\create(MaterialRequiredExport::class),
    "material_required_issue" => \DI\create(MaterialRequiredIssue::class),
    "material_required_job_card" => \DI\create(MaterialRequiredJobCard::class),
    "material_required_live" => \DI\create(MaterialRequiredLive::class),
    "material_required_monthly_cross_company" => \DI\create(MaterialRequiredMonthlyCrossCompany::class),
    "material_required_old" => \DI\create(MaterialRequiredOld::class),
    "material_required_processing_outside" => \DI\create(MaterialRequiredProcessingOutside::class),
    "material_required_processing_outside_old" => \DI\create(MaterialRequiredProcessingOutsideOld::class),
    "material_required_weekly" => \DI\create(MaterialRequiredWeekly::class),
    "material_required_weekly_loomplan" => \DI\create(MaterialRequiredWeeklyLoomplan::class),
    "material_required_weekly_loomplan_short" => \DI\create(MaterialRequiredWeeklyLoomplanShort::class),
    "material_status" => \DI\create(MaterialStatus::class),
    "member_info" => \DI\create(MemberInfo::class),
    "menus" => \DI\create(Menus::class),
    "message_template_admin" => \DI\create(MessageTemplateAdmin::class),
    "message_template_office" => \DI\create(MessageTemplateOffice::class),
    "message_type" => \DI\create(MessageType::class),
    "method" => \DI\create(Method::class),
    "mgs_certificate" => \DI\create(MgsCertificate::class),
    "mgs_certificate_data" => \DI\create(MgsCertificateData::class),
    "mgs_mail" => \DI\create(MgsMail::class),
    "minimum_inventory_level" => \DI\create(MinimumInventoryLevel::class),
    "misc" => \DI\create(Misc::class),
    "misc_items" => \DI\create(MiscItems::class),
    "misc_items_cost" => \DI\create(MiscItemsCost::class),
    "mlogin" => \DI\create(Mlogin::class),
    "mn_record" => \DI\create(MnRecord::class),
    "monthly_production" => \DI\create(MonthlyProduction::class),
    "monthly_production_buyerwise" => \DI\create(MonthlyProductionBuyerwise::class),
    "multiple_price" => \DI\create(MultiplePrice::class),
    "news_letter" => \DI\create(NewsLetter::class),
    "not_month" => \DI\create(NotMonth::class),
    "not_week" => \DI\create(NotWeek::class),
    "not_loomcard" => \DI\create(NotLoomcard::class),
    "oms_table" => \DI\create(OmsTable::class),
    "oms_table_2" => \DI\create(OmsTable2::class),
    "other_all" => \DI\create(OtherAll::class),
    "p_cart" => \DI\create(PCart::class),
    "p_eastimate" => \DI\create(PEastimate::class),
    "p_po" => \DI\create(PPo::class),
    "p_process_wbc" => \DI\create(PProcessWbc::class),
    "p_size" => \DI\create(PSize::class),
    "p_stock" => \DI\create(PStock::class),
    "packing_list" => \DI\create(PackingList::class),
    "packing_list_no" => \DI\create(PackingListNo::class),
    "packing_list_plan" => \DI\create(PackingListPlan::class),
    "packing_list_tmp" => \DI\create(PackingListTmp::class),
    "packing_process_f" => \DI\create(PackingProcessF::class),
    "packing_process_shortage" => \DI\create(PackingProcessShortage::class),
    "packing_table" => \DI\create(PackingTable::class),
    "packing_table_fp" => \DI\create(PackingTableFp::class),
    "packing_type" => \DI\create(PackingType::class),
    "packing_type_table" => \DI\create(PackingTypeTable::class),
    "partner_balance" => \DI\create(PartnerBalance::class),
    "partner_balance_compiled" => \DI\create(PartnerBalanceCompiled::class),
    "partner_product_ref" => \DI\create(PartnerProductRef::class),
    "partner_quotation_buyer" => \DI\create(PartnerQuotationBuyer::class),
    "partner_quotation_pp" => \DI\create(PartnerQuotationPp::class),
    "password_reset_temp" => \DI\create(PasswordResetTemp::class),
    "pay_sprit" => \DI\create(PaySprit::class),
    "payment" => \DI\create(Payment::class),
    "payment_emp_grp_check" => \DI\create(PaymentEmpGrpCheck::class),
    "payment_hs" => \DI\create(PaymentHs::class),
    "payment_period" => \DI\create(PaymentPeriod::class),
    "payment_period_f" => \DI\create(PaymentPeriodF::class),
    "payment_plan" => \DI\create(PaymentPlan::class),
    "payment_plan_check" => \DI\create(PaymentPlanCheck::class),
    "payment_plan_extra_weaving" => \DI\create(PaymentPlanExtraWeaving::class),
    "payment_plan_hs" => \DI\create(PaymentPlanHs::class),
    "payment_plan_material" => \DI\create(PaymentPlanMaterial::class),
    "payment_plan_pending" => \DI\create(PaymentPlanPending::class),
    "payment_response" => \DI\create(PaymentResponse::class),
    "payment_summary2" => \DI\create(PaymentSummary2::class),
    "payroll_benefits" => \DI\create(PayrollBenefits::class),
    "payroll_details" => \DI\create(PayrollDetails::class),
    "payroll_fix_details" => \DI\create(PayrollFixDetails::class),
    "payroll_holidays" => \DI\create(PayrollHolidays::class),
    "payroll_machine_details" => \DI\create(PayrollMachineDetails::class),
    "payroll_machine_log" => \DI\create(PayrollMachineLog::class),
    "payroll_misc" => \DI\create(PayrollMisc::class),
    "payroll_time_log" => \DI\create(PayrollTimeLog::class),
    "personal_info" => \DI\create(PersonalInfo::class),
    "pl_setup" => \DI\create(PlSetup::class),
    "po" => \DI\create(Po::class),
    "po_b" => \DI\create(PoB::class),
    "po_b_app" => \DI\create(PoBApp::class),
    "po_b_auth" => \DI\create(PoBAuth::class),
    "po_b_wbc" => \DI\create(PoBWbc::class),
    "po_desc" => \DI\create(PoDesc::class),
    "po_overall" => \DI\create(PoOverall::class),
    "po_overall_compiled" => \DI\create(PoOverallCompiled::class),
    "po_overall_cross" => \DI\create(PoOverallCross::class),
    "po_pending" => \DI\create(PoPending::class),
    "po_pending_wbc" => \DI\create(PoPendingWbc::class),
    "po_pending_wbc_internal" => \DI\create(PoPendingWbcInternal::class),
    "po_pending_wbc_jobcard" => \DI\create(PoPendingWbcJobcard::class),
    "po_s" => \DI\create(PoS::class),
    "po_s_app" => \DI\create(PoSApp::class),
    "po_s_auth" => \DI\create(PoSAuth::class),
    "po_s_pending" => \DI\create(PoSPending::class),
    "po_s_pending_p_remarks" => \DI\create(PoSPendingPRemarks::class),
    "po_setup" => \DI\create(PoSetup::class),
    "po_status" => \DI\create(PoStatus::class),
    "port" => \DI\create(Port::class),
    "portal_image_size" => \DI\create(PortalImageSize::class),
    "portal_info" => \DI\create(PortalInfo::class),
    "portal_list" => \DI\create(PortalList::class),
    "portal_setup" => \DI\create(PortalSetup::class),
    "portal_updates" => \DI\create(PortalUpdates::class),
    "portal_version" => \DI\create(PortalVersion::class),
    "pp_category" => \DI\create(PpCategory::class),
    "pp_verify" => \DI\create(PpVerify::class),
    "pp_verify_compiled" => \DI\create(PpVerifyCompiled::class),
    "prepone_dispatch" => \DI\create(PreponeDispatch::class),
    "print_family_tree" => \DI\create(PrintFamilyTree::class),
    "print_job_card_bc" => \DI\create(PrintJobCardBc::class),
    "print_job_card_post_data_fp" => \DI\create(PrintJobCardPostDataFp::class),
    "print_job_card_wbc" => \DI\create(PrintJobCardWbc::class),
    "print_pd" => \DI\create(PrintPd::class),
    "print_po" => \DI\create(PrintPo::class),
    "print_po_b" => \DI\create(PrintPoB::class),
    "print_po_c" => \DI\create(PrintPoC::class),
    "print_po_fp" => \DI\create(PrintPoFp::class),
    "print_po_s" => \DI\create(PrintPoS::class),
    "print_sp_label" => \DI\create(PrintSpLabel::class),
    "print_ted" => \DI\create(PrintTed::class),
    "print_ted_c" => \DI\create(PrintTedC::class),
    "print_ted_f" => \DI\create(PrintTedF::class),
    "print_ted_fp" => \DI\create(PrintTedFp::class),
    "privacy_policy" => \DI\create(PrivacyPolicy::class),
    "process" => \DI\create(Process::class),
    "process_action" => \DI\create(ProcessAction::class),
    "process_action_material" => \DI\create(ProcessActionMaterial::class),
    "process_action_material_old" => \DI\create(ProcessActionMaterialOld::class),
    "process_action_material_payment" => \DI\create(ProcessActionMaterialPayment::class),
    "process_action_payment" => \DI\create(ProcessActionPayment::class),
    "process_action_payment_e" => \DI\create(ProcessActionPaymentE::class),
    "process_action_payment_emp_ref_grp" => \DI\create(ProcessActionPaymentEmpRefGrp::class),
    "process_action_payment_pe" => \DI\create(ProcessActionPaymentPe::class),
    "process_action_single" => \DI\create(ProcessActionSingle::class),
    "process_action_single_old" => \DI\create(ProcessActionSingleOld::class),
    "process_house" => \DI\create(ProcessHouse::class),
    "process_mismatch" => \DI\create(ProcessMismatch::class),
    "process_product_f" => \DI\create(ProcessProductF::class),
    "process_table" => \DI\create(ProcessTable::class),
    "process_table_hs" => \DI\create(ProcessTableHs::class),
    "process_table_old" => \DI\create(ProcessTableOld::class),
    "process_type" => \DI\create(ProcessType::class),
    "process_type_g" => \DI\create(ProcessTypeG::class),
    "process_wbc_wpp" => \DI\create(ProcessWbcWpp::class),
    "process_yeild" => \DI\create(ProcessYeild::class),
    "prod_plan_log" => \DI\create(ProdPlanLog::class),
    "product" => \DI\create(Product::class),
    "product_askprice" => \DI\create(ProductAskprice::class),
    "product_cart_b" => \DI\create(ProductCartB::class),
    "product_cart_b_sample" => \DI\create(ProductCartBSample::class),
    "product_cart_b_wbc" => \DI\create(ProductCartBWbc::class),
    "product_cart_s" => \DI\create(ProductCartS::class),
    "product_cart_s_sample" => \DI\create(ProductCartSSample::class),
    "product_category" => \DI\create(ProductCategory::class),
    "product_f" => \DI\create(ProductF::class),
    "product_g" => \DI\create(ProductG::class),
    "product_group" => \DI\create(ProductGroup::class),
    "product_group_cross" => \DI\create(ProductGroupCross::class),
    "product_notify" => \DI\create(ProductNotify::class),
    "product_refer" => \DI\create(ProductRefer::class),
    "product_type" => \DI\create(ProductType::class),
    "product_view2" => \DI\create(ProductView2::class),
    "production_employee" => \DI\create(ProductionEmployee::class),
    "production_employee_hs" => \DI\create(ProductionEmployeeHs::class),
    "production_employee_view2" => \DI\create(ProductionEmployeeView2::class),
    "production_employee_view_pw" => \DI\create(ProductionEmployeeViewPw::class),
    "production_partner" => \DI\create(ProductionPartner::class),
    "production_partner_view2" => \DI\create(ProductionPartnerView2::class),
    "production_plan" => \DI\create(ProductionPlan::class),
    "production_plan_head" => \DI\create(ProductionPlanHead::class),
    "production_plan_jobcard" => \DI\create(ProductionPlanJobcard::class),
    "production_process" => \DI\create(ProductionProcess::class),
    "production_process_f" => \DI\create(ProductionProcessF::class),
    "production_process_g" => \DI\create(ProductionProcessG::class),
    "production_process_live" => \DI\create(ProductionProcessLive::class),
    "production_week_plan" => \DI\create(ProductionWeekPlan::class),
    "promotional_message_text" => \DI\create(PromotionalMessageText::class),
    "property_details" => \DI\create(PropertyDetails::class),
    "property_misc" => \DI\create(PropertyMisc::class),
    "purchase_a" => \DI\create(PurchaseA::class),
    "purchase_a_old" => \DI\create(PurchaseAOld::class),
    "purchase_l" => \DI\create(PurchaseL::class),
    "purchase_l_audit" => \DI\create(PurchaseLAudit::class),
    "purchase_l_audit_old" => \DI\create(PurchaseLAuditOld::class),
    "purchase_l_bc" => \DI\create(PurchaseLBc::class),
    "purchase_l_old" => \DI\create(PurchaseLOld::class),
    "purchase_l_qc" => \DI\create(PurchaseLQc::class),
    "purchase_ref" => \DI\create(PurchaseRef::class),
    "purchase_ref_monthly" => \DI\create(PurchaseRefMonthly::class),
    "qc" => \DI\create(Qc::class),
    "qc_authorised" => \DI\create(QcAuthorised::class),
    "qc_items" => \DI\create(QcItems::class),
    "qc_missing" => \DI\create(QcMissing::class),
    "qc_old" => \DI\create(QcOld::class),
    "qpb_setup" => \DI\create(QpbSetup::class),
    "query_oms" => \DI\create(QueryOms::class),
    "query_oms_2" => \DI\create(QueryOms2::class),
    "query_pppo_pending" => \DI\create(QueryPppoPending::class),
    "query_production" => \DI\create(QueryProduction::class),
    "query_production_table" => \DI\create(QueryProductionTable::class),
    "quotation" => \DI\create(Quotation::class),
    "quotation_setup" => \DI\create(QuotationSetup::class),
    "re" => \DI\create(Re::class),
    "receipt" => \DI\create(Receipt::class),
    "receipt_b" => \DI\create(ReceiptB::class),
    "ref" => \DI\create(Ref::class),
    "ref_code" => \DI\create(RefCode::class),
    "ref_image" => \DI\create(RefImage::class),
    "refer_to_friend" => \DI\create(ReferToFriend::class),
    "refresh_update" => \DI\create(RefreshUpdate::class),
    "rental_cart" => \DI\create(RentalCart::class),
    "rental_po" => \DI\create(RentalPo::class),
    "request2" => \DI\create(Request2::class),
    "request_archive" => \DI\create(RequestArchive::class),
    "request_group" => \DI\create(RequestGroup::class),
    "request_type" => \DI\create(RequestType::class),
    "required_material_compiled" => \DI\create(RequiredMaterialCompiled::class),
    "required_material_compiled_live" => \DI\create(RequiredMaterialCompiledLive::class),
    "required_material_overall_table" => \DI\create(RequiredMaterialOverallTable::class),
    "s_admission_info" => \DI\create(SAdmissionInfo::class),
    "s_attendance" => \DI\create(SAttendance::class),
    "s_attendance_info" => \DI\create(SAttendanceInfo::class),
    "s_epc_backup" => \DI\create(SEpcBackup::class),
    "s_epc_data" => \DI\create(SEpcData::class),
    "s_epc_live" => \DI\create(SEpcLive::class),
    "s_eval_scheme" => \DI\create(SEvalScheme::class),
    "s_faculty" => \DI\create(SFaculty::class),
    "s_inout_time" => \DI\create(SInoutTime::class),
    "s_omr_value" => \DI\create(SOmrValue::class),
    "s_personal_info" => \DI\create(SPersonalInfo::class),
    "s_student_list" => \DI\create(SStudentList::class),
    "salary_expenses" => \DI\create(SalaryExpenses::class),
    "salary_payment" => \DI\create(SalaryPayment::class),
    "sales_ref" => \DI\create(SalesRef::class),
    "sales_ref_monthly" => \DI\create(SalesRefMonthly::class),
    "sample_req" => \DI\create(SampleReq::class),
    "sample_req_cart" => \DI\create(SampleReqCart::class),
    "sample_req_cart_app" => \DI\create(SampleReqCartApp::class),
    "sample_req_cart_auth" => \DI\create(SampleReqCartAuth::class),
    "sample_req_cart_dispatch" => \DI\create(SampleReqCartDispatch::class),
    "sample_req_cart_dispatch_app" => \DI\create(SampleReqCartDispatchApp::class),
    "sample_req_cart_feedback" => \DI\create(SampleReqCartFeedback::class),
    "sample_req_cart_po" => \DI\create(SampleReqCartPo::class),
    "sample_req_cart_pre_dispatch" => \DI\create(SampleReqCartPreDispatch::class),
    "sample_req_cart_status" => \DI\create(SampleReqCartStatus::class),
    "sample_req_misc" => \DI\create(SampleReqMisc::class),
    "sample_request_receive" => \DI\create(SampleRequestReceive::class),
    "sample_request_status" => \DI\create(SampleRequestStatus::class),
    "service_misc" => \DI\create(ServiceMisc::class),
    "service_report" => \DI\create(ServiceReport::class),
    "service_request" => \DI\create(ServiceRequest::class),
    "service_schedule" => \DI\create(ServiceSchedule::class),
    "shade_type" => \DI\create(ShadeType::class),
    "shape" => \DI\create(Shape::class),
    "share_transfer" => \DI\create(ShareTransfer::class),
    "shipping_address" => \DI\create(ShippingAddress::class),
    "shipping_details" => \DI\create(ShippingDetails::class),
    "shipping_line" => \DI\create(ShippingLine::class),
    "shipping_type" => \DI\create(ShippingType::class),
    "shop" => \DI\create(Shop::class),
    "site_search" => \DI\create(SiteSearch::class),
    "sms_record" => \DI\create(SmsRecord::class),
    "sms_setup" => \DI\create(SmsSetup::class),
    "social_icons" => \DI\create(SocialIcons::class),
    "special_permissions" => \DI\create(SpecialPermissions::class),
    "special_task" => \DI\create(SpecialTask::class),
    "static_pages" => \DI\create(StaticPages::class),
    "status" => \DI\create(Status::class),
    "stock" => \DI\create(Stock::class),
    "stock_barcode" => \DI\create(StockBarcode::class),
    "stock_blending" => \DI\create(StockBlending::class),
    "stock_consume" => \DI\create(StockConsume::class),
    "stock_datewise" => \DI\create(StockDatewise::class),
    "stock_godown_transfer" => \DI\create(StockGodownTransfer::class),
    "stock_godown_transfer_old" => \DI\create(StockGodownTransferOld::class),
    "stock_lcgp" => \DI\create(StockLcgp::class),
    "stock_lcgp_all" => \DI\create(StockLcgpAll::class),
    "stock_lcgpd" => \DI\create(StockLcgpd::class),
    "stock_material_out" => \DI\create(StockMaterialOut::class),
    "stock_movement_detailed" => \DI\create(StockMovementDetailed::class),
    "stock_online" => \DI\create(StockOnline::class),
    "stock_packing" => \DI\create(StockPacking::class),
    "stock_process" => \DI\create(StockProcess::class),
    "stock_process_action_material" => \DI\create(StockProcessActionMaterial::class),
    "stock_processing_job" => \DI\create(StockProcessingJob::class),
    "stock_processing_outside" => \DI\create(StockProcessingOutside::class),
    "stock_processing_outside_zerostock" => \DI\create(StockProcessingOutsideZerostock::class),
    "stock_purchase_l" => \DI\create(StockPurchaseL::class),
    "stock_setup" => \DI\create(StockSetup::class),
    "sub_process_type" => \DI\create(SubProcessType::class),
    "sub_process_type_view2" => \DI\create(SubProcessTypeView2::class),
    "subscriptions" => \DI\create(Subscriptions::class),
    "t_balance" => \DI\create(TBalance::class),
    "t_balance_detailed" => \DI\create(TBalanceDetailed::class),
    "t_daily_km" => \DI\create(TDailyKm::class),
    "t_diesal_expenses" => \DI\create(TDiesalExpenses::class),
    "t_diesal_expenses_d" => \DI\create(TDiesalExpensesD::class),
    "t_driver_info" => \DI\create(TDriverInfo::class),
    "t_due_payment" => \DI\create(TDuePayment::class),
    "t_expenses" => \DI\create(TExpenses::class),
    "t_expenses_d" => \DI\create(TExpensesD::class),
    "t_expenses_info" => \DI\create(TExpensesInfo::class),
    "t_expenses_o" => \DI\create(TExpensesO::class),
    "t_fasttag_expenses" => \DI\create(TFasttagExpenses::class),
    "t_ledger" => \DI\create(TLedger::class),
    "t_maintenance" => \DI\create(TMaintenance::class),
    "t_maintenance_exp" => \DI\create(TMaintenanceExp::class),
    "t_maintenance_info" => \DI\create(TMaintenanceInfo::class),
    "t_payment" => \DI\create(TPayment::class),
    "t_payment_bulk" => \DI\create(TPaymentBulk::class),
    "t_receipt_bulk" => \DI\create(TReceiptBulk::class),
    "t_receipt_d" => \DI\create(TReceiptD::class),
    "t_route_info" => \DI\create(TRouteInfo::class),
    "t_trip_balance" => \DI\create(TTripBalance::class),
    "t_trip_buyer" => \DI\create(TTripBuyer::class),
    "t_trip_expenses_detailed" => \DI\create(TTripExpensesDetailed::class),
    "t_trip_expenses_report" => \DI\create(TTripExpensesReport::class),
    "t_trip_info" => \DI\create(TTripInfo::class),
    "t_trip_info_d" => \DI\create(TTripInfoD::class),
    "t_trip_info_d_unload" => \DI\create(TTripInfoDUnload::class),
    "t_trip_loadslip" => \DI\create(TTripLoadslip::class),
    "t_trip_start" => \DI\create(TTripStart::class),
    "t_tyre_info" => \DI\create(TTyreInfo::class),
    "t_tyre_maintenance" => \DI\create(TTyreMaintenance::class),
    "tax_category" => \DI\create(TaxCategory::class),
    "test_report" => \DI\create(TestReport::class),
    "test_report_g" => \DI\create(TestReportG::class),
    "test_report_head" => \DI\create(TestReportHead::class),
    "tmp_lot_query" => \DI\create(TmpLotQuery::class),
    "tmp_notes_bc" => \DI\create(TmpNotesBc::class),
    "tufting_complete" => \DI\create(TuftingComplete::class),
    "tufting_plan" => \DI\create(TuftingPlan::class),
    "tufting_plan_wc" => \DI\create(TuftingPlanWc::class),
    "tufting_plan_wlz" => \DI\create(TuftingPlanWlz::class),
    "unit" => \DI\create(Unit::class),
    "update_event" => \DI\create(UpdateEvent::class),
    "update_old_payment" => \DI\create(UpdateOldPayment::class),
    "upload" => \DI\create(Upload::class),
    "user" => \DI\create(User::class),
    "userlevelpermissions" => \DI\create(Userlevelpermissions::class),
    "userlevels" => \DI\create(Userlevels::class),
    "varient" => \DI\create(Varient::class),
    "varient_view2" => \DI\create(VarientView2::class),
    "vehicle_info" => \DI\create(VehicleInfo::class),
    "weekly_production" => \DI\create(WeeklyProduction::class),
    "weight_comparision" => \DI\create(WeightComparision::class),
    "whatsapp_setup" => \DI\create(WhatsappSetup::class),
    "wool_import_calculator" => \DI\create(WoolImportCalculator::class),
    "wool_import_calculator1" => \DI\create(WoolImportCalculator1::class),
    "world_city" => \DI\create(WorldCity::class),
    "world_city_india" => \DI\create(WorldCityIndia::class),
    "world_country" => \DI\create(WorldCountry::class),
    "world_state" => \DI\create(WorldState::class),
    "ww_color" => \DI\create(WwColor::class),
    "ww_color_req" => \DI\create(WwColorReq::class),
    "ww_color_req_detailed" => \DI\create(WwColorReqDetailed::class),
    "ww_color_req_detailed_2" => \DI\create(WwColorReqDetailed2::class),
    "ww_yarn" => \DI\create(WwYarn::class),
    "ziparchive" => \DI\create(Ziparchive::class),
    "family_info_view2" => \DI\create(FamilyInfoView2::class),
    "documents" => \DI\create(Documents::class),

    // User table
    "usertable" => \DI\get("admin"),
] + $definitions;
