<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "sample_req_cart" table
 */
#[Entity]
#[Table(name: "sample_req_cart")]
class _SampleReqCart extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "request_by", type: "smallint")]
    private int $requestBy;

    #[Column(name: "old_ref", type: "string", nullable: true)]
    private ?string $oldRef;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(type: "string")]
    private string $design;

    #[Column(type: "string")]
    private string $color;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "smallint")]
    private int $quantity;

    #[Column(type: "string", nullable: true)]
    private ?string $comments;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "po_id", type: "smallint", nullable: true)]
    private ?int $poId;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "shipping_mode", type: "integer", nullable: true)]
    private ?int $shippingMode;

    #[Column(name: "delivery_week", type: "smallint", nullable: true)]
    private ?int $deliveryWeek;

    #[Column(type: "smallint", nullable: true)]
    private ?int $purpose;

    #[Column(type: "string", nullable: true)]
    private ?string $label;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $ssd;

    #[Column(name: "shipping_address", type: "smallint", nullable: true)]
    private ?int $shippingAddress;

    #[Column(name: "shipping_address_2", type: "text", nullable: true)]
    private ?string $shippingAddress2;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "sp_remarks", type: "string", nullable: true)]
    private ?string $spRemarks;

    #[Column(name: "pp_remarks", type: "string", nullable: true)]
    private ?string $ppRemarks;

    #[Column(name: "po_remarks", type: "string", nullable: true)]
    private ?string $poRemarks;

    #[Column(type: "string", nullable: true)]
    private ?string $price;

    #[Column(type: "string", nullable: true)]
    private ?string $declaration;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "app_operator", type: "smallint", nullable: true)]
    private ?int $appOperator;

    #[Column(name: "app_datetime", type: "datetime", nullable: true)]
    private ?DateTime $appDatetime;

    #[Column(name: "po_operator", type: "smallint", nullable: true)]
    private ?int $poOperator;

    #[Column(name: "po_datetime", type: "datetime", nullable: true)]
    private ?DateTime $poDatetime;

    #[Column(type: "string")]
    private string $bom;

    #[Column(type: "string", nullable: true)]
    private ?string $dispatch;

    #[Column(name: "pd_upload", type: "string", nullable: true)]
    private ?string $pdUpload;

    #[Column(name: "d_operator", type: "smallint", nullable: true)]
    private ?int $dOperator;

    #[Column(name: "d_datetime", type: "datetime", nullable: true)]
    private ?DateTime $dDatetime;

    #[Column(name: "r_comments", type: "string", nullable: true)]
    private ?string $rComments;

    #[Column(name: "r_operator", type: "smallint", nullable: true)]
    private ?int $rOperator;

    #[Column(name: "r_datetime", type: "datetime", nullable: true)]
    private ?DateTime $rDatetime;

    #[Column(name: "f_yn", type: "smallint", nullable: true)]
    private ?int $fYn;

    #[Column(type: "text", nullable: true)]
    private ?string $feedback;

    #[Column(name: "f_upload", type: "string", nullable: true)]
    private ?string $fUpload;

    #[Column(name: "f_operator", type: "smallint", nullable: true)]
    private ?int $fOperator;

    #[Column(name: "f_datetime", type: "datetime", nullable: true)]
    private ?DateTime $fDatetime;

    #[Column(name: "r_text", type: "string", nullable: true)]
    private ?string $rText;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(name: "fr_operator", type: "smallint", nullable: true)]
    private ?int $frOperator;

    #[Column(name: "fr_datetime", type: "datetime", nullable: true)]
    private ?DateTime $frDatetime;

    #[Column(name: "app_status", type: "smallint")]
    private int $appStatus;

    #[Column(name: "da_comments", type: "string", nullable: true)]
    private ?string $daComments;

    #[Column(name: "da_status", type: "smallint", nullable: true)]
    private ?int $daStatus;

    #[Column(name: "da_operator", type: "smallint", nullable: true)]
    private ?int $daOperator;

    #[Column(name: "da_datetime", type: "datetime", nullable: true)]
    private ?DateTime $daDatetime;

    #[Column(name: "req_chat_id", type: "string", nullable: true)]
    private ?string $reqChatId;

    #[Column(name: "pd_operator", type: "smallint")]
    private int $pdOperator;

    #[Column(name: "pd_comments", type: "string", nullable: true)]
    private ?string $pdComments;

    #[Column(name: "pd_datetime", type: "datetime", nullable: true)]
    private ?DateTime $pdDatetime;

    #[Column(name: "d_upload", type: "string", nullable: true)]
    private ?string $dUpload;

    public function __construct()
    {
        $this->requestBy = ((isset($_COOKIE["buye"]))? $_COOKIE["buye"]:CurrentUserID());
        $this->operator = 0;
        $this->companyId = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
        $this->partnerId = (isset($_GET["PID"]))? $_GET["PID"]:'';
        $this->bom = "Please Update Product Specification i.e. BOM, CBM, Weight/SQM, Price, MOQ etc";
        $this->appStatus = 0;
        $this->daStatus = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRequestBy(): int
    {
        return $this->requestBy;
    }

    public function setRequestBy(int $value): static
    {
        $this->requestBy = $value;
        return $this;
    }

    public function getOldRef(): ?string
    {
        return HtmlDecode($this->oldRef);
    }

    public function setOldRef(?string $value): static
    {
        $this->oldRef = RemoveXss($value);
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getDesign(): string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getColor(): string
    {
        return HtmlDecode($this->color);
    }

    public function setColor(string $value): static
    {
        $this->color = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getComments(): ?string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(?string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPoId(): ?int
    {
        return $this->poId;
    }

    public function setPoId(?int $value): static
    {
        $this->poId = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getShippingMode(): ?int
    {
        return $this->shippingMode;
    }

    public function setShippingMode(?int $value): static
    {
        $this->shippingMode = $value;
        return $this;
    }

    public function getDeliveryWeek(): ?int
    {
        return $this->deliveryWeek;
    }

    public function setDeliveryWeek(?int $value): static
    {
        $this->deliveryWeek = $value;
        return $this;
    }

    public function getPurpose(): ?int
    {
        return $this->purpose;
    }

    public function setPurpose(?int $value): static
    {
        $this->purpose = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getSsd(): ?DateTime
    {
        return $this->ssd;
    }

    public function setSsd(?DateTime $value): static
    {
        $this->ssd = $value;
        return $this;
    }

    public function getShippingAddress(): ?int
    {
        return $this->shippingAddress;
    }

    public function setShippingAddress(?int $value): static
    {
        $this->shippingAddress = $value;
        return $this;
    }

    public function getShippingAddress2(): ?string
    {
        return HtmlDecode($this->shippingAddress2);
    }

    public function setShippingAddress2(?string $value): static
    {
        $this->shippingAddress2 = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getSpRemarks(): ?string
    {
        return HtmlDecode($this->spRemarks);
    }

    public function setSpRemarks(?string $value): static
    {
        $this->spRemarks = RemoveXss($value);
        return $this;
    }

    public function getPpRemarks(): ?string
    {
        return HtmlDecode($this->ppRemarks);
    }

    public function setPpRemarks(?string $value): static
    {
        $this->ppRemarks = RemoveXss($value);
        return $this;
    }

    public function getPoRemarks(): ?string
    {
        return HtmlDecode($this->poRemarks);
    }

    public function setPoRemarks(?string $value): static
    {
        $this->poRemarks = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return HtmlDecode($this->price);
    }

    public function setPrice(?string $value): static
    {
        $this->price = RemoveXss($value);
        return $this;
    }

    public function getDeclaration(): ?string
    {
        return HtmlDecode($this->declaration);
    }

    public function setDeclaration(?string $value): static
    {
        $this->declaration = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getAppOperator(): ?int
    {
        return $this->appOperator;
    }

    public function setAppOperator(?int $value): static
    {
        $this->appOperator = $value;
        return $this;
    }

    public function getAppDatetime(): ?DateTime
    {
        return $this->appDatetime;
    }

    public function setAppDatetime(?DateTime $value): static
    {
        $this->appDatetime = $value;
        return $this;
    }

    public function getPoOperator(): ?int
    {
        return $this->poOperator;
    }

    public function setPoOperator(?int $value): static
    {
        $this->poOperator = $value;
        return $this;
    }

    public function getPoDatetime(): ?DateTime
    {
        return $this->poDatetime;
    }

    public function setPoDatetime(?DateTime $value): static
    {
        $this->poDatetime = $value;
        return $this;
    }

    public function getBom(): string
    {
        return HtmlDecode($this->bom);
    }

    public function setBom(string $value): static
    {
        $this->bom = RemoveXss($value);
        return $this;
    }

    public function getDispatch(): ?string
    {
        return HtmlDecode($this->dispatch);
    }

    public function setDispatch(?string $value): static
    {
        $this->dispatch = RemoveXss($value);
        return $this;
    }

    public function getPdUpload(): ?string
    {
        return HtmlDecode($this->pdUpload);
    }

    public function setPdUpload(?string $value): static
    {
        $this->pdUpload = RemoveXss($value);
        return $this;
    }

    public function getDOperator(): ?int
    {
        return $this->dOperator;
    }

    public function setDOperator(?int $value): static
    {
        $this->dOperator = $value;
        return $this;
    }

    public function getDDatetime(): ?DateTime
    {
        return $this->dDatetime;
    }

    public function setDDatetime(?DateTime $value): static
    {
        $this->dDatetime = $value;
        return $this;
    }

    public function getRComments(): ?string
    {
        return HtmlDecode($this->rComments);
    }

    public function setRComments(?string $value): static
    {
        $this->rComments = RemoveXss($value);
        return $this;
    }

    public function getROperator(): ?int
    {
        return $this->rOperator;
    }

    public function setROperator(?int $value): static
    {
        $this->rOperator = $value;
        return $this;
    }

    public function getRDatetime(): ?DateTime
    {
        return $this->rDatetime;
    }

    public function setRDatetime(?DateTime $value): static
    {
        $this->rDatetime = $value;
        return $this;
    }

    public function getFYn(): ?int
    {
        return $this->fYn;
    }

    public function setFYn(?int $value): static
    {
        $this->fYn = $value;
        return $this;
    }

    public function getFeedback(): ?string
    {
        return HtmlDecode($this->feedback);
    }

    public function setFeedback(?string $value): static
    {
        $this->feedback = RemoveXss($value);
        return $this;
    }

    public function getFUpload(): ?string
    {
        return HtmlDecode($this->fUpload);
    }

    public function setFUpload(?string $value): static
    {
        $this->fUpload = RemoveXss($value);
        return $this;
    }

    public function getFOperator(): ?int
    {
        return $this->fOperator;
    }

    public function setFOperator(?int $value): static
    {
        $this->fOperator = $value;
        return $this;
    }

    public function getFDatetime(): ?DateTime
    {
        return $this->fDatetime;
    }

    public function setFDatetime(?DateTime $value): static
    {
        $this->fDatetime = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getFrOperator(): ?int
    {
        return $this->frOperator;
    }

    public function setFrOperator(?int $value): static
    {
        $this->frOperator = $value;
        return $this;
    }

    public function getFrDatetime(): ?DateTime
    {
        return $this->frDatetime;
    }

    public function setFrDatetime(?DateTime $value): static
    {
        $this->frDatetime = $value;
        return $this;
    }

    public function getAppStatus(): int
    {
        return $this->appStatus;
    }

    public function setAppStatus(int $value): static
    {
        $this->appStatus = $value;
        return $this;
    }

    public function getDaComments(): ?string
    {
        return HtmlDecode($this->daComments);
    }

    public function setDaComments(?string $value): static
    {
        $this->daComments = RemoveXss($value);
        return $this;
    }

    public function getDaStatus(): ?int
    {
        return $this->daStatus;
    }

    public function setDaStatus(?int $value): static
    {
        $this->daStatus = $value;
        return $this;
    }

    public function getDaOperator(): ?int
    {
        return $this->daOperator;
    }

    public function setDaOperator(?int $value): static
    {
        $this->daOperator = $value;
        return $this;
    }

    public function getDaDatetime(): ?DateTime
    {
        return $this->daDatetime;
    }

    public function setDaDatetime(?DateTime $value): static
    {
        $this->daDatetime = $value;
        return $this;
    }

    public function getReqChatId(): ?string
    {
        return HtmlDecode($this->reqChatId);
    }

    public function setReqChatId(?string $value): static
    {
        $this->reqChatId = RemoveXss($value);
        return $this;
    }

    public function getPdOperator(): int
    {
        return $this->pdOperator;
    }

    public function setPdOperator(int $value): static
    {
        $this->pdOperator = $value;
        return $this;
    }

    public function getPdComments(): ?string
    {
        return HtmlDecode($this->pdComments);
    }

    public function setPdComments(?string $value): static
    {
        $this->pdComments = RemoveXss($value);
        return $this;
    }

    public function getPdDatetime(): ?DateTime
    {
        return $this->pdDatetime;
    }

    public function setPdDatetime(?DateTime $value): static
    {
        $this->pdDatetime = $value;
        return $this;
    }

    public function getDUpload(): ?string
    {
        return HtmlDecode($this->dUpload);
    }

    public function setDUpload(?string $value): static
    {
        $this->dUpload = RemoveXss($value);
        return $this;
    }
}
