<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "sample_req" table
 */
#[Entity]
#[Table(name: "sample_req")]
class _SampleReq extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(name: "sample_cart_id", type: "string", nullable: true)]
    private ?string $sampleCartId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $purpose;

    #[Column(type: "string", nullable: true)]
    private ?string $label;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $ssd;

    #[Column(name: "shipping_mode", type: "integer", nullable: true)]
    private ?int $shippingMode;

    #[Column(name: "delivery_week", type: "smallint", nullable: true)]
    private ?int $deliveryWeek;

    #[Column(name: "shipping_address", type: "smallint", nullable: true)]
    private ?int $shippingAddress;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $upload;

    #[Column(name: "shipping_address_2", type: "text", nullable: true)]
    private ?string $shippingAddress2;

    public function __construct()
    {
        $this->buyerId = ((isset($_COOKIE["buye"]))? $_COOKIE["buye"]:CurrentUserID());
        $this->sampleCartId = ((isset($_COOKIE["caid"]))? $_COOKIE["caid"]:'');
        $this->purpose = ((isset($_COOKIE["pur"]))? $_COOKIE["pur"]:'');
        $this->label = ((isset($_COOKIE["label"]))? $_COOKIE["label"]:'');
        $this->shippingMode = ((isset($_COOKIE["sm"]))? $_COOKIE["sm"]:'');
        $this->deliveryWeek = ((isset($_COOKIE["dw"]))? $_COOKIE["dw"]:'');
        $this->shippingAddress = ((isset($_COOKIE["ship"]))? $_COOKIE["ship"]:'');
        $this->remarks = ((isset($_COOKIE["rem"]))? $_COOKIE["rem"]:'');
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getSampleCartId(): ?string
    {
        return HtmlDecode($this->sampleCartId);
    }

    public function setSampleCartId(?string $value): static
    {
        $this->sampleCartId = RemoveXss($value);
        return $this;
    }

    public function getPurpose(): ?int
    {
        return $this->purpose;
    }

    public function setPurpose(?int $value): static
    {
        $this->purpose = $value;
        return $this;
    }

    public function getLabel(): ?string
    {
        return HtmlDecode($this->label);
    }

    public function setLabel(?string $value): static
    {
        $this->label = RemoveXss($value);
        return $this;
    }

    public function getSsd(): ?DateTime
    {
        return $this->ssd;
    }

    public function setSsd(?DateTime $value): static
    {
        $this->ssd = $value;
        return $this;
    }

    public function getShippingMode(): ?int
    {
        return $this->shippingMode;
    }

    public function setShippingMode(?int $value): static
    {
        $this->shippingMode = $value;
        return $this;
    }

    public function getDeliveryWeek(): ?int
    {
        return $this->deliveryWeek;
    }

    public function setDeliveryWeek(?int $value): static
    {
        $this->deliveryWeek = $value;
        return $this;
    }

    public function getShippingAddress(): ?int
    {
        return $this->shippingAddress;
    }

    public function setShippingAddress(?int $value): static
    {
        $this->shippingAddress = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getUpload(): ?string
    {
        return HtmlDecode($this->upload);
    }

    public function setUpload(?string $value): static
    {
        $this->upload = RemoveXss($value);
        return $this;
    }

    public function getShippingAddress2(): ?string
    {
        return HtmlDecode($this->shippingAddress2);
    }

    public function setShippingAddress2(?string $value): static
    {
        $this->shippingAddress2 = RemoveXss($value);
        return $this;
    }
}
