<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "po" table
 */
#[Entity]
#[Table(name: "po")]
class _Po extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "order_type", type: "integer")]
    private int $orderType;

    #[Column(name: "buyer_id", type: "integer")]
    private int $buyerId;

    #[Column(name: "buyer_order_no", type: "string", nullable: true)]
    private ?string $buyerOrderNo;

    #[Column(name: "buyer_order_date", type: "date", nullable: true)]
    private ?DateTime $buyerOrderDate;

    #[Column(name: "cart_id", type: "text", nullable: true)]
    private ?string $cartId;

    #[Column(name: "buyer_product_ref", type: "text", nullable: true)]
    private ?string $buyerProductRef;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "despatch_date", type: "date")]
    private DateTime $despatchDate;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "fob_date", type: "date")]
    private DateTime $fobDate;

    #[Column(name: "part_dispatch", type: "smallint")]
    private int $partDispatch;

    #[Column(name: "payment_terms", type: "string")]
    private string $paymentTerms;

    #[Column(name: "transport_terms", type: "string")]
    private string $transportTerms;

    #[Column(name: "`buyer_shipping _id`", options: ["name" => "buyer_shipping _id"], type: "smallint")]
    private int $buyerShippingId;

    #[Column(name: "description_04", type: "float", nullable: true)]
    private ?float $description04;

    #[Column(name: "description_03", type: "float", nullable: true)]
    private ?float $description03;

    #[Column(name: "description_01", type: "float", nullable: true)]
    private ?float $description01;

    #[Column(name: "description_02", type: "float", nullable: true)]
    private ?float $description02;

    #[Column(name: "description_07", type: "smallint", nullable: true)]
    private ?int $description07;

    #[Column(name: "description_20", type: "smallint")]
    private int $description20;

    #[Column(name: "description_17", type: "float")]
    private float $description17;

    #[Column(name: "description_18", type: "float")]
    private float $description18;

    #[Column(name: "description_19", type: "float")]
    private float $description19;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(type: "smallint")]
    private int $currency;

    #[Column(type: "float")]
    private float $amount;

    #[Column(type: "float")]
    private float $cbm;

    #[Column(name: "buyer_size", type: "string")]
    private string $buyerSize;

    #[Column(name: "description_05", type: "smallint", nullable: true)]
    private ?int $description05;

    #[Column(name: "description_06", type: "smallint", nullable: true)]
    private ?int $description06;

    #[Column(name: "description_08", type: "smallint", nullable: true)]
    private ?int $description08;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "a_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aDatetime;

    #[Column(name: "jc_no", type: "string", nullable: true)]
    private ?string $jcNo;

    #[Column(name: "buyer_instruction", type: "string", nullable: true)]
    private ?string $buyerInstruction;

    #[Column(name: "d_09_head", type: "smallint", nullable: true)]
    private ?int $d09Head;

    #[Column(name: "description_09", type: "string", nullable: true)]
    private ?string $description09;

    #[Column(name: "d_10_head", type: "smallint", nullable: true)]
    private ?int $d10Head;

    #[Column(name: "description_10", type: "string", nullable: true)]
    private ?string $description10;

    #[Column(name: "d_11_head", type: "smallint", nullable: true)]
    private ?int $d11Head;

    #[Column(name: "description_11", type: "string", nullable: true)]
    private ?string $description11;

    #[Column(name: "d_12_head", type: "smallint", nullable: true)]
    private ?int $d12Head;

    #[Column(name: "description_12", type: "string", nullable: true)]
    private ?string $description12;

    #[Column(type: "smallint")]
    private int $po;

    #[Column(name: "production_site", type: "smallint")]
    private int $productionSite;

    #[Column(name: "c_total", type: "smallint")]
    private int $cTotal;

    #[Column(name: "production_plan", type: "smallint", nullable: true)]
    private ?int $productionPlan;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "product_gcode", type: "string", nullable: true)]
    private ?string $productGcode;

    #[Column(name: "batch_no", type: "smallint")]
    private int $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "d_01_head", type: "smallint", nullable: true)]
    private ?int $d01Head;

    #[Column(name: "d_02_head", type: "smallint", nullable: true)]
    private ?int $d02Head;

    #[Column(name: "d_03_head", type: "smallint", nullable: true)]
    private ?int $d03Head;

    #[Column(name: "d_04_head", type: "smallint", nullable: true)]
    private ?int $d04Head;

    #[Column(name: "d_05_head", type: "smallint", nullable: true)]
    private ?int $d05Head;

    #[Column(name: "d_06_head", type: "smallint", nullable: true)]
    private ?int $d06Head;

    #[Column(name: "d_07_head", type: "smallint", nullable: true)]
    private ?int $d07Head;

    #[Column(name: "d_08_head", type: "smallint", nullable: true)]
    private ?int $d08Head;

    #[Column(type: "smallint")]
    private int $sample;

    #[Column(name: "balance_quantity", type: "decimal", nullable: true)]
    private ?string $balanceQuantity;

    public function __construct()
    {
        $this->orderType = 0;
        $this->despatchWeek = date('W');
        $this->description04 = 0;
        $this->description03 = 1;
        $this->description20 = 1;
        $this->operator = 0;
        $this->po = 0000;
        $this->balanceQuantity = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getOrderType(): int
    {
        return $this->orderType;
    }

    public function setOrderType(int $value): static
    {
        $this->orderType = $value;
        return $this;
    }

    public function getBuyerId(): int
    {
        return $this->buyerId;
    }

    public function setBuyerId(int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getBuyerOrderNo(): ?string
    {
        return HtmlDecode($this->buyerOrderNo);
    }

    public function setBuyerOrderNo(?string $value): static
    {
        $this->buyerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getBuyerOrderDate(): ?DateTime
    {
        return $this->buyerOrderDate;
    }

    public function setBuyerOrderDate(?DateTime $value): static
    {
        $this->buyerOrderDate = $value;
        return $this;
    }

    public function getCartId(): ?string
    {
        return HtmlDecode($this->cartId);
    }

    public function setCartId(?string $value): static
    {
        $this->cartId = RemoveXss($value);
        return $this;
    }

    public function getBuyerProductRef(): ?string
    {
        return HtmlDecode($this->buyerProductRef);
    }

    public function setBuyerProductRef(?string $value): static
    {
        $this->buyerProductRef = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getDespatchDate(): DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getFobDate(): DateTime
    {
        return $this->fobDate;
    }

    public function setFobDate(DateTime $value): static
    {
        $this->fobDate = $value;
        return $this;
    }

    public function getPartDispatch(): int
    {
        return $this->partDispatch;
    }

    public function setPartDispatch(int $value): static
    {
        $this->partDispatch = $value;
        return $this;
    }

    public function getPaymentTerms(): string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getTransportTerms(): string
    {
        return HtmlDecode($this->transportTerms);
    }

    public function setTransportTerms(string $value): static
    {
        $this->transportTerms = RemoveXss($value);
        return $this;
    }

    public function getBuyerShippingId(): int
    {
        return $this->buyerShippingId;
    }

    public function setBuyerShippingId(int $value): static
    {
        $this->buyerShippingId = $value;
        return $this;
    }

    public function getDescription04(): ?float
    {
        return $this->description04;
    }

    public function setDescription04(?float $value): static
    {
        $this->description04 = $value;
        return $this;
    }

    public function getDescription03(): ?float
    {
        return $this->description03;
    }

    public function setDescription03(?float $value): static
    {
        $this->description03 = $value;
        return $this;
    }

    public function getDescription01(): ?float
    {
        return $this->description01;
    }

    public function setDescription01(?float $value): static
    {
        $this->description01 = $value;
        return $this;
    }

    public function getDescription02(): ?float
    {
        return $this->description02;
    }

    public function setDescription02(?float $value): static
    {
        $this->description02 = $value;
        return $this;
    }

    public function getDescription07(): ?int
    {
        return $this->description07;
    }

    public function setDescription07(?int $value): static
    {
        $this->description07 = $value;
        return $this;
    }

    public function getDescription20(): int
    {
        return $this->description20;
    }

    public function setDescription20(int $value): static
    {
        $this->description20 = $value;
        return $this;
    }

    public function getDescription17(): float
    {
        return $this->description17;
    }

    public function setDescription17(float $value): static
    {
        $this->description17 = $value;
        return $this;
    }

    public function getDescription18(): float
    {
        return $this->description18;
    }

    public function setDescription18(float $value): static
    {
        $this->description18 = $value;
        return $this;
    }

    public function getDescription19(): float
    {
        return $this->description19;
    }

    public function setDescription19(float $value): static
    {
        $this->description19 = $value;
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getCurrency(): int
    {
        return $this->currency;
    }

    public function setCurrency(int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCbm(): float
    {
        return $this->cbm;
    }

    public function setCbm(float $value): static
    {
        $this->cbm = $value;
        return $this;
    }

    public function getBuyerSize(): string
    {
        return HtmlDecode($this->buyerSize);
    }

    public function setBuyerSize(string $value): static
    {
        $this->buyerSize = RemoveXss($value);
        return $this;
    }

    public function getDescription05(): ?int
    {
        return $this->description05;
    }

    public function setDescription05(?int $value): static
    {
        $this->description05 = $value;
        return $this;
    }

    public function getDescription06(): ?int
    {
        return $this->description06;
    }

    public function setDescription06(?int $value): static
    {
        $this->description06 = $value;
        return $this;
    }

    public function getDescription08(): ?int
    {
        return $this->description08;
    }

    public function setDescription08(?int $value): static
    {
        $this->description08 = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): ?DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(?DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getJcNo(): ?string
    {
        return HtmlDecode($this->jcNo);
    }

    public function setJcNo(?string $value): static
    {
        $this->jcNo = RemoveXss($value);
        return $this;
    }

    public function getBuyerInstruction(): ?string
    {
        return HtmlDecode($this->buyerInstruction);
    }

    public function setBuyerInstruction(?string $value): static
    {
        $this->buyerInstruction = RemoveXss($value);
        return $this;
    }

    public function getD09Head(): ?int
    {
        return $this->d09Head;
    }

    public function setD09Head(?int $value): static
    {
        $this->d09Head = $value;
        return $this;
    }

    public function getDescription09(): ?string
    {
        return HtmlDecode($this->description09);
    }

    public function setDescription09(?string $value): static
    {
        $this->description09 = RemoveXss($value);
        return $this;
    }

    public function getD10Head(): ?int
    {
        return $this->d10Head;
    }

    public function setD10Head(?int $value): static
    {
        $this->d10Head = $value;
        return $this;
    }

    public function getDescription10(): ?string
    {
        return HtmlDecode($this->description10);
    }

    public function setDescription10(?string $value): static
    {
        $this->description10 = RemoveXss($value);
        return $this;
    }

    public function getD11Head(): ?int
    {
        return $this->d11Head;
    }

    public function setD11Head(?int $value): static
    {
        $this->d11Head = $value;
        return $this;
    }

    public function getDescription11(): ?string
    {
        return HtmlDecode($this->description11);
    }

    public function setDescription11(?string $value): static
    {
        $this->description11 = RemoveXss($value);
        return $this;
    }

    public function getD12Head(): ?int
    {
        return $this->d12Head;
    }

    public function setD12Head(?int $value): static
    {
        $this->d12Head = $value;
        return $this;
    }

    public function getDescription12(): ?string
    {
        return HtmlDecode($this->description12);
    }

    public function setDescription12(?string $value): static
    {
        $this->description12 = RemoveXss($value);
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getProductionSite(): int
    {
        return $this->productionSite;
    }

    public function setProductionSite(int $value): static
    {
        $this->productionSite = $value;
        return $this;
    }

    public function getCTotal(): int
    {
        return $this->cTotal;
    }

    public function setCTotal(int $value): static
    {
        $this->cTotal = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getProductGcode(): ?string
    {
        return HtmlDecode($this->productGcode);
    }

    public function setProductGcode(?string $value): static
    {
        $this->productGcode = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): int
    {
        return $this->batchNo;
    }

    public function setBatchNo(int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getD01Head(): ?int
    {
        return $this->d01Head;
    }

    public function setD01Head(?int $value): static
    {
        $this->d01Head = $value;
        return $this;
    }

    public function getD02Head(): ?int
    {
        return $this->d02Head;
    }

    public function setD02Head(?int $value): static
    {
        $this->d02Head = $value;
        return $this;
    }

    public function getD03Head(): ?int
    {
        return $this->d03Head;
    }

    public function setD03Head(?int $value): static
    {
        $this->d03Head = $value;
        return $this;
    }

    public function getD04Head(): ?int
    {
        return $this->d04Head;
    }

    public function setD04Head(?int $value): static
    {
        $this->d04Head = $value;
        return $this;
    }

    public function getD05Head(): ?int
    {
        return $this->d05Head;
    }

    public function setD05Head(?int $value): static
    {
        $this->d05Head = $value;
        return $this;
    }

    public function getD06Head(): ?int
    {
        return $this->d06Head;
    }

    public function setD06Head(?int $value): static
    {
        $this->d06Head = $value;
        return $this;
    }

    public function getD07Head(): ?int
    {
        return $this->d07Head;
    }

    public function setD07Head(?int $value): static
    {
        $this->d07Head = $value;
        return $this;
    }

    public function getD08Head(): ?int
    {
        return $this->d08Head;
    }

    public function setD08Head(?int $value): static
    {
        $this->d08Head = $value;
        return $this;
    }

    public function getSample(): int
    {
        return $this->sample;
    }

    public function setSample(int $value): static
    {
        $this->sample = $value;
        return $this;
    }

    public function getBalanceQuantity(): ?string
    {
        return $this->balanceQuantity;
    }

    public function setBalanceQuantity(?string $value): static
    {
        $this->balanceQuantity = $value;
        return $this;
    }
}
