<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bcode" table
 */
#[Entity]
#[Table(name: "bcode")]
class _Bcode extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "decimal", nullable: true)]
    private ?string $pid;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(type: "integer", unique: true)]
    private int $barcode;

    #[Column(name: "process_d", type: "string", nullable: true)]
    private ?string $processD;

    #[Column(name: "buyer_ref", type: "smallint", nullable: true)]
    private ?int $buyerRef;

    #[Column(name: "order_date", type: "date", nullable: true)]
    private ?DateTime $orderDate;

    #[Column(name: "despatch_date", type: "date", nullable: true)]
    private ?DateTime $despatchDate;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "dispatch_week_p", type: "smallint", nullable: true)]
    private ?int $dispatchWeekP;

    #[Column(name: "loom_plan", type: "string")]
    private string $loomPlan;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "buyer_uid", type: "string", nullable: true)]
    private ?string $buyerUid;

    #[Column(name: "buyer_loc", type: "string")]
    private string $buyerLoc;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(type: "decimal")]
    private string $sqm;

    #[Column(name: "sqm_u", type: "float", nullable: true)]
    private ?float $sqmU;

    #[Column(name: "c_sqm", type: "decimal")]
    private string $cSqm;

    #[Column(name: "weaving_works", type: "smallint")]
    private int $weavingWorks;

    #[Column(name: "current_works", type: "smallint")]
    private int $currentWorks;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(name: "q_sku", type: "decimal")]
    private string $qSku;

    #[Column(name: "po_price", type: "string", nullable: true)]
    private ?string $poPrice;

    #[Column(name: "po_discount", type: "decimal")]
    private string $poDiscount;

    #[Column(name: "po_currency", type: "smallint", nullable: true)]
    private ?int $poCurrency;

    #[Column(name: "product_type", type: "smallint")]
    private int $productType;

    #[Column(type: "integer")]
    private int $shape;

    #[Column(name: "payment_plan", type: "smallint", nullable: true)]
    private ?int $paymentPlan;

    #[Column(name: "production_plan", type: "integer", nullable: true)]
    private ?int $productionPlan;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $completed;

    #[Column(name: "buyer_po", type: "string", nullable: true)]
    private ?string $buyerPo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "sqm_a", type: "float")]
    private float $sqmA;

    #[Column(type: "float")]
    private float $2srm;

    #[Column(name: "`2srm_a`", options: ["name" => "2srm_a"], type: "float")]
    private float $2srmA;

    #[Column(type: "float")]
    private float $4srm;

    #[Column(name: "`4srm_a`", options: ["name" => "4srm_a"], type: "float")]
    private float $4srmA;

    #[Column(name: "buyer_tid", type: "string", nullable: true)]
    private ?string $buyerTid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "integer")]
    private int $cs;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "process_c", type: "string", nullable: true)]
    private ?string $processC;

    #[Column(type: "decimal", nullable: true)]
    private ?string $weight;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "p_remarks", type: "string", nullable: true)]
    private ?string $pRemarks;

    #[Column(name: "roll_no", type: "smallint", nullable: true)]
    private ?int $rollNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $qty;

    #[Column(name: "pl_no", type: "decimal")]
    private string $plNo;

    #[Column(type: "string")]
    private string $category;

    #[Column(name: "pp_id", type: "integer", nullable: true)]
    private ?int $ppId;

    #[Column(type: "integer", nullable: true)]
    private ?int $consignee;

    #[Column(name: "buyer_barcode", type: "string", nullable: true)]
    private ?string $buyerBarcode;

    #[Column(name: "design_next", type: "string", nullable: true)]
    private ?string $designNext;

    #[Column(type: "string", nullable: true)]
    private ?string $11;

    #[Column(type: "string", nullable: true)]
    private ?string $12;

    #[Column(type: "string", nullable: true)]
    private ?string $13;

    #[Column(type: "string", nullable: true)]
    private ?string $14;

    #[Column(type: "string", nullable: true)]
    private ?string $15;

    #[Column(type: "string", nullable: true)]
    private ?string $16;

    #[Column(type: "string", nullable: true)]
    private ?string $17;

    #[Column(type: "string", nullable: true)]
    private ?string $18;

    #[Column(type: "string", nullable: true)]
    private ?string $19;

    #[Column(type: "string", nullable: true)]
    private ?string $20;

    #[Column(type: "string", nullable: true)]
    private ?string $21;

    #[Column(type: "string", nullable: true)]
    private ?string $22;

    #[Column(type: "string", nullable: true)]
    private ?string $23;

    #[Column(type: "string", nullable: true)]
    private ?string $24;

    #[Column(type: "string", nullable: true)]
    private ?string $25;

    #[Column(type: "string", nullable: true)]
    private ?string $26;

    #[Column(type: "string", nullable: true)]
    private ?string $27;

    #[Column(type: "string", nullable: true)]
    private ?string $28;

    #[Column(type: "string", nullable: true)]
    private ?string $29;

    #[Column(type: "string", nullable: true)]
    private ?string $30;

    #[Column(type: "string", nullable: true)]
    private ?string $31;

    #[Column(type: "string", nullable: true)]
    private ?string $32;

    #[Column(type: "string", nullable: true)]
    private ?string $33;

    #[Column(type: "string", nullable: true)]
    private ?string $34;

    #[Column(type: "string", nullable: true)]
    private ?string $35;

    #[Column(type: "string", nullable: true)]
    private ?string $36;

    #[Column(type: "string", nullable: true)]
    private ?string $37;

    #[Column(type: "string", nullable: true)]
    private ?string $38;

    #[Column(type: "string", nullable: true)]
    private ?string $39;

    #[Column(type: "string", nullable: true)]
    private ?string $40;

    #[Column(type: "string", nullable: true)]
    private ?string $41;

    #[Column(type: "string", nullable: true)]
    private ?string $42;

    #[Column(type: "string", nullable: true)]
    private ?string $43;

    #[Column(type: "string", nullable: true)]
    private ?string $44;

    #[Column(type: "string", nullable: true)]
    private ?string $45;

    #[Column(type: "string", nullable: true)]
    private ?string $46;

    #[Column(type: "string", nullable: true)]
    private ?string $47;

    #[Column(type: "string", nullable: true)]
    private ?string $48;

    #[Column(type: "string", nullable: true)]
    private ?string $49;

    #[Column(type: "string", nullable: true)]
    private ?string $50;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "qc_weaving", type: "date", nullable: true)]
    private ?DateTime $qcWeaving;

    #[Column(name: "roll_no_qty_tmp", type: "decimal")]
    private string $rollNoQtyTmp;

    public function __construct()
    {
        $this->po = 99999;
        $this->barcode = 99999;
        $this->loomPlan = "0";
        $this->status = 0;
        $this->buyerLoc = "0";
        $this->quantity = 1;
        $this->sqm = "0";
        $this->cSqm = "0.00";
        $this->weavingWorks = 0;
        $this->currentWorks = 0;
        $this->qSku = "1.00";
        $this->poDiscount = "0.00";
        $this->completed = 0;
        $this->operator = 0;
        $this->jcNo = 99999999;
        $this->cs = 0;
        $this->pRemarks = "--NA--";
        $this->plNo = "0.00";
        $this->packingType = 301;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPid(): ?string
    {
        return $this->pid;
    }

    public function setPid(?string $value): static
    {
        $this->pid = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getProcessD(): ?string
    {
        return HtmlDecode($this->processD);
    }

    public function setProcessD(?string $value): static
    {
        $this->processD = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?int
    {
        return $this->buyerRef;
    }

    public function setBuyerRef(?int $value): static
    {
        $this->buyerRef = $value;
        return $this;
    }

    public function getOrderDate(): ?DateTime
    {
        return $this->orderDate;
    }

    public function setOrderDate(?DateTime $value): static
    {
        $this->orderDate = $value;
        return $this;
    }

    public function getDespatchDate(): ?DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(?DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getDispatchWeekP(): ?int
    {
        return $this->dispatchWeekP;
    }

    public function setDispatchWeekP(?int $value): static
    {
        $this->dispatchWeekP = $value;
        return $this;
    }

    public function getLoomPlan(): string
    {
        return HtmlDecode($this->loomPlan);
    }

    public function setLoomPlan(string $value): static
    {
        $this->loomPlan = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getBuyerLoc(): string
    {
        return HtmlDecode($this->buyerLoc);
    }

    public function setBuyerLoc(string $value): static
    {
        $this->buyerLoc = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getSqm(): string
    {
        return $this->sqm;
    }

    public function setSqm(string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmU(): ?float
    {
        return $this->sqmU;
    }

    public function setSqmU(?float $value): static
    {
        $this->sqmU = $value;
        return $this;
    }

    public function getCSqm(): string
    {
        return $this->cSqm;
    }

    public function setCSqm(string $value): static
    {
        $this->cSqm = $value;
        return $this;
    }

    public function getWeavingWorks(): int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getCurrentWorks(): int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getQSku(): string
    {
        return $this->qSku;
    }

    public function setQSku(string $value): static
    {
        $this->qSku = $value;
        return $this;
    }

    public function getPoPrice(): ?string
    {
        return HtmlDecode($this->poPrice);
    }

    public function setPoPrice(?string $value): static
    {
        $this->poPrice = RemoveXss($value);
        return $this;
    }

    public function getPoDiscount(): string
    {
        return $this->poDiscount;
    }

    public function setPoDiscount(string $value): static
    {
        $this->poDiscount = $value;
        return $this;
    }

    public function getPoCurrency(): ?int
    {
        return $this->poCurrency;
    }

    public function setPoCurrency(?int $value): static
    {
        $this->poCurrency = $value;
        return $this;
    }

    public function getProductType(): int
    {
        return $this->productType;
    }

    public function setProductType(int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getShape(): int
    {
        return $this->shape;
    }

    public function setShape(int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getPaymentPlan(): ?int
    {
        return $this->paymentPlan;
    }

    public function setPaymentPlan(?int $value): static
    {
        $this->paymentPlan = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCompleted(): ?int
    {
        return $this->completed;
    }

    public function setCompleted(?int $value): static
    {
        $this->completed = $value;
        return $this;
    }

    public function getBuyerPo(): ?string
    {
        return HtmlDecode($this->buyerPo);
    }

    public function setBuyerPo(?string $value): static
    {
        $this->buyerPo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getSqmA(): float
    {
        return $this->sqmA;
    }

    public function setSqmA(float $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function get2srm(): float
    {
        return $this->2srm;
    }

    public function set2srm(float $value): static
    {
        $this->2srm = $value;
        return $this;
    }

    public function get2srmA(): float
    {
        return $this->2srmA;
    }

    public function set2srmA(float $value): static
    {
        $this->2srmA = $value;
        return $this;
    }

    public function get4srm(): float
    {
        return $this->4srm;
    }

    public function set4srm(float $value): static
    {
        $this->4srm = $value;
        return $this;
    }

    public function get4srmA(): float
    {
        return $this->4srmA;
    }

    public function set4srmA(float $value): static
    {
        $this->4srmA = $value;
        return $this;
    }

    public function getBuyerTid(): ?string
    {
        return HtmlDecode($this->buyerTid);
    }

    public function setBuyerTid(?string $value): static
    {
        $this->buyerTid = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getCs(): int
    {
        return $this->cs;
    }

    public function setCs(int $value): static
    {
        $this->cs = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getProcessC(): ?string
    {
        return HtmlDecode($this->processC);
    }

    public function setProcessC(?string $value): static
    {
        $this->processC = RemoveXss($value);
        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $value): static
    {
        $this->weight = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPRemarks(): ?string
    {
        return HtmlDecode($this->pRemarks);
    }

    public function setPRemarks(?string $value): static
    {
        $this->pRemarks = RemoveXss($value);
        return $this;
    }

    public function getRollNo(): ?int
    {
        return $this->rollNo;
    }

    public function setRollNo(?int $value): static
    {
        $this->rollNo = $value;
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getPlNo(): string
    {
        return $this->plNo;
    }

    public function setPlNo(string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getCategory(): string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getPpId(): ?int
    {
        return $this->ppId;
    }

    public function setPpId(?int $value): static
    {
        $this->ppId = $value;
        return $this;
    }

    public function getConsignee(): ?int
    {
        return $this->consignee;
    }

    public function setConsignee(?int $value): static
    {
        $this->consignee = $value;
        return $this;
    }

    public function getBuyerBarcode(): ?string
    {
        return HtmlDecode($this->buyerBarcode);
    }

    public function setBuyerBarcode(?string $value): static
    {
        $this->buyerBarcode = RemoveXss($value);
        return $this;
    }

    public function getDesignNext(): ?string
    {
        return HtmlDecode($this->designNext);
    }

    public function setDesignNext(?string $value): static
    {
        $this->designNext = RemoveXss($value);
        return $this;
    }

    public function get11(): ?string
    {
        return HtmlDecode($this->11);
    }

    public function set11(?string $value): static
    {
        $this->11 = RemoveXss($value);
        return $this;
    }

    public function get12(): ?string
    {
        return HtmlDecode($this->12);
    }

    public function set12(?string $value): static
    {
        $this->12 = RemoveXss($value);
        return $this;
    }

    public function get13(): ?string
    {
        return HtmlDecode($this->13);
    }

    public function set13(?string $value): static
    {
        $this->13 = RemoveXss($value);
        return $this;
    }

    public function get14(): ?string
    {
        return HtmlDecode($this->14);
    }

    public function set14(?string $value): static
    {
        $this->14 = RemoveXss($value);
        return $this;
    }

    public function get15(): ?string
    {
        return HtmlDecode($this->15);
    }

    public function set15(?string $value): static
    {
        $this->15 = RemoveXss($value);
        return $this;
    }

    public function get16(): ?string
    {
        return HtmlDecode($this->16);
    }

    public function set16(?string $value): static
    {
        $this->16 = RemoveXss($value);
        return $this;
    }

    public function get17(): ?string
    {
        return HtmlDecode($this->17);
    }

    public function set17(?string $value): static
    {
        $this->17 = RemoveXss($value);
        return $this;
    }

    public function get18(): ?string
    {
        return HtmlDecode($this->18);
    }

    public function set18(?string $value): static
    {
        $this->18 = RemoveXss($value);
        return $this;
    }

    public function get19(): ?string
    {
        return HtmlDecode($this->19);
    }

    public function set19(?string $value): static
    {
        $this->19 = RemoveXss($value);
        return $this;
    }

    public function get20(): ?string
    {
        return HtmlDecode($this->20);
    }

    public function set20(?string $value): static
    {
        $this->20 = RemoveXss($value);
        return $this;
    }

    public function get21(): ?string
    {
        return HtmlDecode($this->21);
    }

    public function set21(?string $value): static
    {
        $this->21 = RemoveXss($value);
        return $this;
    }

    public function get22(): ?string
    {
        return HtmlDecode($this->22);
    }

    public function set22(?string $value): static
    {
        $this->22 = RemoveXss($value);
        return $this;
    }

    public function get23(): ?string
    {
        return HtmlDecode($this->23);
    }

    public function set23(?string $value): static
    {
        $this->23 = RemoveXss($value);
        return $this;
    }

    public function get24(): ?string
    {
        return HtmlDecode($this->24);
    }

    public function set24(?string $value): static
    {
        $this->24 = RemoveXss($value);
        return $this;
    }

    public function get25(): ?string
    {
        return HtmlDecode($this->25);
    }

    public function set25(?string $value): static
    {
        $this->25 = RemoveXss($value);
        return $this;
    }

    public function get26(): ?string
    {
        return HtmlDecode($this->26);
    }

    public function set26(?string $value): static
    {
        $this->26 = RemoveXss($value);
        return $this;
    }

    public function get27(): ?string
    {
        return HtmlDecode($this->27);
    }

    public function set27(?string $value): static
    {
        $this->27 = RemoveXss($value);
        return $this;
    }

    public function get28(): ?string
    {
        return HtmlDecode($this->28);
    }

    public function set28(?string $value): static
    {
        $this->28 = RemoveXss($value);
        return $this;
    }

    public function get29(): ?string
    {
        return HtmlDecode($this->29);
    }

    public function set29(?string $value): static
    {
        $this->29 = RemoveXss($value);
        return $this;
    }

    public function get30(): ?string
    {
        return HtmlDecode($this->30);
    }

    public function set30(?string $value): static
    {
        $this->30 = RemoveXss($value);
        return $this;
    }

    public function get31(): ?string
    {
        return HtmlDecode($this->31);
    }

    public function set31(?string $value): static
    {
        $this->31 = RemoveXss($value);
        return $this;
    }

    public function get32(): ?string
    {
        return HtmlDecode($this->32);
    }

    public function set32(?string $value): static
    {
        $this->32 = RemoveXss($value);
        return $this;
    }

    public function get33(): ?string
    {
        return HtmlDecode($this->33);
    }

    public function set33(?string $value): static
    {
        $this->33 = RemoveXss($value);
        return $this;
    }

    public function get34(): ?string
    {
        return HtmlDecode($this->34);
    }

    public function set34(?string $value): static
    {
        $this->34 = RemoveXss($value);
        return $this;
    }

    public function get35(): ?string
    {
        return HtmlDecode($this->35);
    }

    public function set35(?string $value): static
    {
        $this->35 = RemoveXss($value);
        return $this;
    }

    public function get36(): ?string
    {
        return HtmlDecode($this->36);
    }

    public function set36(?string $value): static
    {
        $this->36 = RemoveXss($value);
        return $this;
    }

    public function get37(): ?string
    {
        return HtmlDecode($this->37);
    }

    public function set37(?string $value): static
    {
        $this->37 = RemoveXss($value);
        return $this;
    }

    public function get38(): ?string
    {
        return HtmlDecode($this->38);
    }

    public function set38(?string $value): static
    {
        $this->38 = RemoveXss($value);
        return $this;
    }

    public function get39(): ?string
    {
        return HtmlDecode($this->39);
    }

    public function set39(?string $value): static
    {
        $this->39 = RemoveXss($value);
        return $this;
    }

    public function get40(): ?string
    {
        return HtmlDecode($this->40);
    }

    public function set40(?string $value): static
    {
        $this->40 = RemoveXss($value);
        return $this;
    }

    public function get41(): ?string
    {
        return HtmlDecode($this->41);
    }

    public function set41(?string $value): static
    {
        $this->41 = RemoveXss($value);
        return $this;
    }

    public function get42(): ?string
    {
        return HtmlDecode($this->42);
    }

    public function set42(?string $value): static
    {
        $this->42 = RemoveXss($value);
        return $this;
    }

    public function get43(): ?string
    {
        return HtmlDecode($this->43);
    }

    public function set43(?string $value): static
    {
        $this->43 = RemoveXss($value);
        return $this;
    }

    public function get44(): ?string
    {
        return HtmlDecode($this->44);
    }

    public function set44(?string $value): static
    {
        $this->44 = RemoveXss($value);
        return $this;
    }

    public function get45(): ?string
    {
        return HtmlDecode($this->45);
    }

    public function set45(?string $value): static
    {
        $this->45 = RemoveXss($value);
        return $this;
    }

    public function get46(): ?string
    {
        return HtmlDecode($this->46);
    }

    public function set46(?string $value): static
    {
        $this->46 = RemoveXss($value);
        return $this;
    }

    public function get47(): ?string
    {
        return HtmlDecode($this->47);
    }

    public function set47(?string $value): static
    {
        $this->47 = RemoveXss($value);
        return $this;
    }

    public function get48(): ?string
    {
        return HtmlDecode($this->48);
    }

    public function set48(?string $value): static
    {
        $this->48 = RemoveXss($value);
        return $this;
    }

    public function get49(): ?string
    {
        return HtmlDecode($this->49);
    }

    public function set49(?string $value): static
    {
        $this->49 = RemoveXss($value);
        return $this;
    }

    public function get50(): ?string
    {
        return HtmlDecode($this->50);
    }

    public function set50(?string $value): static
    {
        $this->50 = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getQcWeaving(): ?DateTime
    {
        return $this->qcWeaving;
    }

    public function setQcWeaving(?DateTime $value): static
    {
        $this->qcWeaving = $value;
        return $this;
    }

    public function getRollNoQtyTmp(): string
    {
        return $this->rollNoQtyTmp;
    }

    public function setRollNoQtyTmp(string $value): static
    {
        $this->rollNoQtyTmp = $value;
        return $this;
    }
}
