<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ww_color_req_detailed_2" table
 */
#[Entity]
#[Table(name: "ww_color_req_detailed_2")]
class WwColorReqDetailed2 extends AbstractEntity
{
    #[Column(name: "Yarn", type: "text", nullable: true)]
    private ?string $yarn;

    #[Column(type: "float")]
    private float $forcast;

    #[Column(type: "string")]
    private string $ply;

    #[Column(name: "req_qty", type: "float")]
    private float $reqQty;

    #[Column(type: "smallint", nullable: true)]
    private ?int $standard;

    #[Column(type: "smallint", nullable: true)]
    private ?int $clariant;

    #[Column(type: "smallint", nullable: true)]
    private ?int $poddar;

    #[Column(type: "smallint", nullable: true)]
    private ?int $polyone;

    #[Column(type: "smallint", nullable: true)]
    private ?int $period;

    public function __construct()
    {
        $this->forcast = 0;
        $this->reqQty = 0;
    }

    public function getYarn(): ?string
    {
        return HtmlDecode($this->yarn);
    }

    public function setYarn(?string $value): static
    {
        $this->yarn = RemoveXss($value);
        return $this;
    }

    public function getForcast(): float
    {
        return $this->forcast;
    }

    public function setForcast(float $value): static
    {
        $this->forcast = $value;
        return $this;
    }

    public function getPly(): string
    {
        return HtmlDecode($this->ply);
    }

    public function setPly(string $value): static
    {
        $this->ply = RemoveXss($value);
        return $this;
    }

    public function getReqQty(): float
    {
        return $this->reqQty;
    }

    public function setReqQty(float $value): static
    {
        $this->reqQty = $value;
        return $this;
    }

    public function getStandard(): ?int
    {
        return $this->standard;
    }

    public function setStandard(?int $value): static
    {
        $this->standard = $value;
        return $this;
    }

    public function getClariant(): ?int
    {
        return $this->clariant;
    }

    public function setClariant(?int $value): static
    {
        $this->clariant = $value;
        return $this;
    }

    public function getPoddar(): ?int
    {
        return $this->poddar;
    }

    public function setPoddar(?int $value): static
    {
        $this->poddar = $value;
        return $this;
    }

    public function getPolyone(): ?int
    {
        return $this->polyone;
    }

    public function setPolyone(?int $value): static
    {
        $this->polyone = $value;
        return $this;
    }

    public function getPeriod(): ?int
    {
        return $this->period;
    }

    public function setPeriod(?int $value): static
    {
        $this->period = $value;
        return $this;
    }
}
