<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "ww_color_req_detailed" table
 */
#[Entity]
#[Table(name: "ww_color_req_detailed")]
class WwColorReqDetailed extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $yarn;

    #[Column(name: "consumption_forcast", type: "float", nullable: true)]
    private ?float $consumptionForcast;

    #[Column(name: "p1_c_qty", type: "float", nullable: true)]
    private ?float $p1CQty;

    #[Column(name: "p1_st", type: "smallint", nullable: true)]
    private ?int $p1St;

    #[Column(name: "p1_clariant", type: "smallint", nullable: true)]
    private ?int $p1Clariant;

    #[Column(name: "p1_poddar", type: "smallint", nullable: true)]
    private ?int $p1Poddar;

    #[Column(name: "p1_polyone", type: "smallint", nullable: true)]
    private ?int $p1Polyone;

    #[Column(name: "p2_c_qty", type: "float", nullable: true)]
    private ?float $p2CQty;

    #[Column(name: "p2_st", type: "smallint", nullable: true)]
    private ?int $p2St;

    #[Column(name: "p2_clariant", type: "smallint", nullable: true)]
    private ?int $p2Clariant;

    #[Column(name: "p2_poddar", type: "smallint", nullable: true)]
    private ?int $p2Poddar;

    #[Column(name: "p2_polyone", type: "smallint", nullable: true)]
    private ?int $p2Polyone;

    #[Column(name: "p3_c_qty", type: "float", nullable: true)]
    private ?float $p3CQty;

    #[Column(name: "p3_st", type: "smallint", nullable: true)]
    private ?int $p3St;

    #[Column(name: "p3_clariant", type: "smallint", nullable: true)]
    private ?int $p3Clariant;

    #[Column(name: "p3_poddar", type: "smallint", nullable: true)]
    private ?int $p3Poddar;

    #[Column(name: "p3_polyone", type: "smallint", nullable: true)]
    private ?int $p3Polyone;

    #[Column(type: "smallint", nullable: true)]
    private ?int $period;

    public function __construct()
    {
        $this->consumptionForcast = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getYarn(): ?string
    {
        return HtmlDecode($this->yarn);
    }

    public function setYarn(?string $value): static
    {
        $this->yarn = RemoveXss($value);
        return $this;
    }

    public function getConsumptionForcast(): ?float
    {
        return $this->consumptionForcast;
    }

    public function setConsumptionForcast(?float $value): static
    {
        $this->consumptionForcast = $value;
        return $this;
    }

    public function getP1CQty(): ?float
    {
        return $this->p1CQty;
    }

    public function setP1CQty(?float $value): static
    {
        $this->p1CQty = $value;
        return $this;
    }

    public function getP1St(): ?int
    {
        return $this->p1St;
    }

    public function setP1St(?int $value): static
    {
        $this->p1St = $value;
        return $this;
    }

    public function getP1Clariant(): ?int
    {
        return $this->p1Clariant;
    }

    public function setP1Clariant(?int $value): static
    {
        $this->p1Clariant = $value;
        return $this;
    }

    public function getP1Poddar(): ?int
    {
        return $this->p1Poddar;
    }

    public function setP1Poddar(?int $value): static
    {
        $this->p1Poddar = $value;
        return $this;
    }

    public function getP1Polyone(): ?int
    {
        return $this->p1Polyone;
    }

    public function setP1Polyone(?int $value): static
    {
        $this->p1Polyone = $value;
        return $this;
    }

    public function getP2CQty(): ?float
    {
        return $this->p2CQty;
    }

    public function setP2CQty(?float $value): static
    {
        $this->p2CQty = $value;
        return $this;
    }

    public function getP2St(): ?int
    {
        return $this->p2St;
    }

    public function setP2St(?int $value): static
    {
        $this->p2St = $value;
        return $this;
    }

    public function getP2Clariant(): ?int
    {
        return $this->p2Clariant;
    }

    public function setP2Clariant(?int $value): static
    {
        $this->p2Clariant = $value;
        return $this;
    }

    public function getP2Poddar(): ?int
    {
        return $this->p2Poddar;
    }

    public function setP2Poddar(?int $value): static
    {
        $this->p2Poddar = $value;
        return $this;
    }

    public function getP2Polyone(): ?int
    {
        return $this->p2Polyone;
    }

    public function setP2Polyone(?int $value): static
    {
        $this->p2Polyone = $value;
        return $this;
    }

    public function getP3CQty(): ?float
    {
        return $this->p3CQty;
    }

    public function setP3CQty(?float $value): static
    {
        $this->p3CQty = $value;
        return $this;
    }

    public function getP3St(): ?int
    {
        return $this->p3St;
    }

    public function setP3St(?int $value): static
    {
        $this->p3St = $value;
        return $this;
    }

    public function getP3Clariant(): ?int
    {
        return $this->p3Clariant;
    }

    public function setP3Clariant(?int $value): static
    {
        $this->p3Clariant = $value;
        return $this;
    }

    public function getP3Poddar(): ?int
    {
        return $this->p3Poddar;
    }

    public function setP3Poddar(?int $value): static
    {
        $this->p3Poddar = $value;
        return $this;
    }

    public function getP3Polyone(): ?int
    {
        return $this->p3Polyone;
    }

    public function setP3Polyone(?int $value): static
    {
        $this->p3Polyone = $value;
        return $this;
    }

    public function getPeriod(): ?int
    {
        return $this->period;
    }

    public function setPeriod(?int $value): static
    {
        $this->period = $value;
        return $this;
    }
}
