<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "wool_import_calculator1" table
 */
#[Entity]
#[Table(name: "wool_import_calculator1")]
class WoolImportCalculator1 extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "godown_arrival_date", type: "datetime", nullable: true)]
    private ?DateTime $godownArrivalDate;

    #[Column(name: "net_weight", type: "decimal")]
    private string $netWeight;

    #[Column(type: "decimal")]
    private string $containers;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(name: "purchase_amount", type: "decimal", nullable: true)]
    private ?string $purchaseAmount;

    #[Column(name: "purchase_custom_duty", type: "string", nullable: true)]
    private ?string $purchaseCustomDuty;

    #[Column(name: "s_custom_duty", type: "string", nullable: true)]
    private ?string $sCustomDuty;

    #[Column(name: "port_clearing_charge", type: "string", nullable: true)]
    private ?string $portClearingCharge;

    #[Column(name: "s_port_clearing_charge", type: "string", nullable: true)]
    private ?string $sPortClearingCharge;

    #[Column(name: "cha_commission", type: "string", nullable: true)]
    private ?string $chaCommission;

    #[Column(name: "s_cha_commission", type: "string", nullable: true)]
    private ?string $sChaCommission;

    #[Column(name: "transportation_charges", type: "string", nullable: true)]
    private ?string $transportationCharges;

    #[Column(name: "s_transportation_charges", type: "string", nullable: true)]
    private ?string $sTransportationCharges;

    #[Column(name: "unloading_charges", type: "string", nullable: true)]
    private ?string $unloadingCharges;

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getGodownArrivalDate(): ?DateTime
    {
        return $this->godownArrivalDate;
    }

    public function setGodownArrivalDate(?DateTime $value): static
    {
        $this->godownArrivalDate = $value;
        return $this;
    }

    public function getNetWeight(): string
    {
        return $this->netWeight;
    }

    public function setNetWeight(string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function getContainers(): string
    {
        return $this->containers;
    }

    public function setContainers(string $value): static
    {
        $this->containers = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPurchaseAmount(): ?string
    {
        return $this->purchaseAmount;
    }

    public function setPurchaseAmount(?string $value): static
    {
        $this->purchaseAmount = $value;
        return $this;
    }

    public function getPurchaseCustomDuty(): ?string
    {
        return HtmlDecode($this->purchaseCustomDuty);
    }

    public function setPurchaseCustomDuty(?string $value): static
    {
        $this->purchaseCustomDuty = RemoveXss($value);
        return $this;
    }

    public function getSCustomDuty(): ?string
    {
        return HtmlDecode($this->sCustomDuty);
    }

    public function setSCustomDuty(?string $value): static
    {
        $this->sCustomDuty = RemoveXss($value);
        return $this;
    }

    public function getPortClearingCharge(): ?string
    {
        return HtmlDecode($this->portClearingCharge);
    }

    public function setPortClearingCharge(?string $value): static
    {
        $this->portClearingCharge = RemoveXss($value);
        return $this;
    }

    public function getSPortClearingCharge(): ?string
    {
        return HtmlDecode($this->sPortClearingCharge);
    }

    public function setSPortClearingCharge(?string $value): static
    {
        $this->sPortClearingCharge = RemoveXss($value);
        return $this;
    }

    public function getChaCommission(): ?string
    {
        return HtmlDecode($this->chaCommission);
    }

    public function setChaCommission(?string $value): static
    {
        $this->chaCommission = RemoveXss($value);
        return $this;
    }

    public function getSChaCommission(): ?string
    {
        return HtmlDecode($this->sChaCommission);
    }

    public function setSChaCommission(?string $value): static
    {
        $this->sChaCommission = RemoveXss($value);
        return $this;
    }

    public function getTransportationCharges(): ?string
    {
        return HtmlDecode($this->transportationCharges);
    }

    public function setTransportationCharges(?string $value): static
    {
        $this->transportationCharges = RemoveXss($value);
        return $this;
    }

    public function getSTransportationCharges(): ?string
    {
        return HtmlDecode($this->sTransportationCharges);
    }

    public function setSTransportationCharges(?string $value): static
    {
        $this->sTransportationCharges = RemoveXss($value);
        return $this;
    }

    public function getUnloadingCharges(): ?string
    {
        return HtmlDecode($this->unloadingCharges);
    }

    public function setUnloadingCharges(?string $value): static
    {
        $this->unloadingCharges = RemoveXss($value);
        return $this;
    }
}
