<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "wool_import_calculator" table
 */
#[Entity]
#[Table(name: "wool_import_calculator")]
class WoolImportCalculator extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "net_weight", type: "decimal")]
    private string $netWeight;

    #[Column(name: "actual_cost", type: "float", nullable: true)]
    private ?float $actualCost;

    #[Column(name: "avg_cost", type: "float", nullable: true)]
    private ?float $avgCost;

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getNetWeight(): string
    {
        return $this->netWeight;
    }

    public function setNetWeight(string $value): static
    {
        $this->netWeight = $value;
        return $this;
    }

    public function getActualCost(): ?float
    {
        return $this->actualCost;
    }

    public function setActualCost(?float $value): static
    {
        $this->actualCost = $value;
        return $this;
    }

    public function getAvgCost(): ?float
    {
        return $this->avgCost;
    }

    public function setAvgCost(?float $value): static
    {
        $this->avgCost = $value;
        return $this;
    }
}
