<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "whatsapp_setup" table
 */
#[Entity]
#[Table(name: "whatsapp_setup")]
class WhatsappSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $mobile;

    #[Column(type: "string")]
    private string $url;

    #[Column(name: "instance_id", type: "string")]
    private string $instanceId;

    #[Column(type: "string")]
    private string $token;

    #[Column(type: "string")]
    private string $company;

    #[Column(name: "direct_whatsapp", type: "integer", nullable: true)]
    private ?int $directWhatsapp;

    #[Column(name: "whatsapp_message", type: "text", nullable: true)]
    private ?string $whatsappMessage;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->directWhatsapp = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMobile(): string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getInstanceId(): string
    {
        return HtmlDecode($this->instanceId);
    }

    public function setInstanceId(string $value): static
    {
        $this->instanceId = RemoveXss($value);
        return $this;
    }

    public function getToken(): string
    {
        return HtmlDecode($this->token);
    }

    public function setToken(string $value): static
    {
        $this->token = RemoveXss($value);
        return $this;
    }

    public function getCompany(): string
    {
        return HtmlDecode($this->company);
    }

    public function setCompany(string $value): static
    {
        $this->company = RemoveXss($value);
        return $this;
    }

    public function getDirectWhatsapp(): ?int
    {
        return $this->directWhatsapp;
    }

    public function setDirectWhatsapp(?int $value): static
    {
        $this->directWhatsapp = $value;
        return $this;
    }

    public function getWhatsappMessage(): ?string
    {
        return HtmlDecode($this->whatsappMessage);
    }

    public function setWhatsappMessage(?string $value): static
    {
        $this->whatsappMessage = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
