<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "weight_comparision" table
 */
#[Entity]
#[Table(name: "weight_comparision")]
class WeightComparision extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $barcode;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(type: "string")]
    private string $size;

    #[Column(name: "size_actual", type: "string", nullable: true)]
    private ?string $sizeActual;

    #[Column(name: "s_weight", type: "decimal", nullable: true)]
    private ?string $sWeight;

    #[Column(name: "a_weight", type: "decimal", nullable: true)]
    private ?string $aWeight;

    #[Column(name: "diff_p", type: "decimal", nullable: true)]
    private ?string $diffP;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    public function __construct()
    {
        $this->barcode = 0;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getSizeActual(): ?string
    {
        return HtmlDecode($this->sizeActual);
    }

    public function setSizeActual(?string $value): static
    {
        $this->sizeActual = RemoveXss($value);
        return $this;
    }

    public function getSWeight(): ?string
    {
        return $this->sWeight;
    }

    public function setSWeight(?string $value): static
    {
        $this->sWeight = $value;
        return $this;
    }

    public function getAWeight(): ?string
    {
        return $this->aWeight;
    }

    public function setAWeight(?string $value): static
    {
        $this->aWeight = $value;
        return $this;
    }

    public function getDiffP(): ?string
    {
        return $this->diffP;
    }

    public function setDiffP(?string $value): static
    {
        $this->diffP = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }
}
