<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "weekly_production" table
 */
#[Entity]
#[Table(name: "weekly_production")]
class WeeklyProduction extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $week;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "string", nullable: true)]
    private ?string $category;

    #[Column(type: "smallint")]
    private int $process;

    #[Column(type: "bigint")]
    private string $pcs;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    public function __construct()
    {
        $this->pcs = "0";
    }

    public function getWeek(): ?int
    {
        return $this->week;
    }

    public function setWeek(?int $value): static
    {
        $this->week = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getProcess(): int
    {
        return $this->process;
    }

    public function setProcess(int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getPcs(): string
    {
        return $this->pcs;
    }

    public function setPcs(string $value): static
    {
        $this->pcs = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }
}
