<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "vehicle_info" table
 */
#[Entity]
#[Table(name: "vehicle_info")]
class VehicleInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(name: "vehicle_owner", type: "integer", nullable: true)]
    private ?int $vehicleOwner;

    #[Column(type: "string")]
    private string $no;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(name: "driver_name", type: "string", nullable: true)]
    private ?string $driverName;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dor;

    #[Column(name: "km_hour", type: "decimal", nullable: true)]
    private ?string $kmHour;

    #[Column(name: "chassis_no", type: "string", nullable: true)]
    private ?string $chassisNo;

    #[Column(name: "engine_no", type: "string", nullable: true)]
    private ?string $engineNo;

    #[Column(name: "load_average", type: "decimal", nullable: true)]
    private ?string $loadAverage;

    #[Column(name: "unload_average", type: "decimal", nullable: true)]
    private ?string $unloadAverage;

    #[Column(name: "load_expenses", type: "decimal", nullable: true)]
    private ?string $loadExpenses;

    #[Column(name: "unload_expenses", type: "decimal", nullable: true)]
    private ?string $unloadExpenses;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $insurance;

    #[Column(name: "state_tax", type: "date", nullable: true)]
    private ?DateTime $stateTax;

    #[Column(name: "national_permit", type: "date", nullable: true)]
    private ?DateTime $nationalPermit;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $pollution;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $fitness;

    #[Column(name: "other_due", type: "date", nullable: true)]
    private ?DateTime $otherDue;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "running_status", type: "smallint")]
    private int $runningStatus;

    public function __construct()
    {
        $this->type = 1;
        $this->kmHour = "0.00";
        $this->status = 1;
        $this->operator = 0;
        $this->runningStatus = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getVehicleOwner(): ?int
    {
        return $this->vehicleOwner;
    }

    public function setVehicleOwner(?int $value): static
    {
        $this->vehicleOwner = $value;
        return $this;
    }

    public function getNo(): string
    {
        return HtmlDecode($this->no);
    }

    public function setNo(string $value): static
    {
        $this->no = RemoveXss($value);
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getDriverName(): ?string
    {
        return HtmlDecode($this->driverName);
    }

    public function setDriverName(?string $value): static
    {
        $this->driverName = RemoveXss($value);
        return $this;
    }

    public function getDor(): ?DateTime
    {
        return $this->dor;
    }

    public function setDor(?DateTime $value): static
    {
        $this->dor = $value;
        return $this;
    }

    public function getKmHour(): ?string
    {
        return $this->kmHour;
    }

    public function setKmHour(?string $value): static
    {
        $this->kmHour = $value;
        return $this;
    }

    public function getChassisNo(): ?string
    {
        return HtmlDecode($this->chassisNo);
    }

    public function setChassisNo(?string $value): static
    {
        $this->chassisNo = RemoveXss($value);
        return $this;
    }

    public function getEngineNo(): ?string
    {
        return HtmlDecode($this->engineNo);
    }

    public function setEngineNo(?string $value): static
    {
        $this->engineNo = RemoveXss($value);
        return $this;
    }

    public function getLoadAverage(): ?string
    {
        return $this->loadAverage;
    }

    public function setLoadAverage(?string $value): static
    {
        $this->loadAverage = $value;
        return $this;
    }

    public function getUnloadAverage(): ?string
    {
        return $this->unloadAverage;
    }

    public function setUnloadAverage(?string $value): static
    {
        $this->unloadAverage = $value;
        return $this;
    }

    public function getLoadExpenses(): ?string
    {
        return $this->loadExpenses;
    }

    public function setLoadExpenses(?string $value): static
    {
        $this->loadExpenses = $value;
        return $this;
    }

    public function getUnloadExpenses(): ?string
    {
        return $this->unloadExpenses;
    }

    public function setUnloadExpenses(?string $value): static
    {
        $this->unloadExpenses = $value;
        return $this;
    }

    public function getInsurance(): ?DateTime
    {
        return $this->insurance;
    }

    public function setInsurance(?DateTime $value): static
    {
        $this->insurance = $value;
        return $this;
    }

    public function getStateTax(): ?DateTime
    {
        return $this->stateTax;
    }

    public function setStateTax(?DateTime $value): static
    {
        $this->stateTax = $value;
        return $this;
    }

    public function getNationalPermit(): ?DateTime
    {
        return $this->nationalPermit;
    }

    public function setNationalPermit(?DateTime $value): static
    {
        $this->nationalPermit = $value;
        return $this;
    }

    public function getPollution(): ?DateTime
    {
        return $this->pollution;
    }

    public function setPollution(?DateTime $value): static
    {
        $this->pollution = $value;
        return $this;
    }

    public function getFitness(): ?DateTime
    {
        return $this->fitness;
    }

    public function setFitness(?DateTime $value): static
    {
        $this->fitness = $value;
        return $this;
    }

    public function getOtherDue(): ?DateTime
    {
        return $this->otherDue;
    }

    public function setOtherDue(?DateTime $value): static
    {
        $this->otherDue = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRunningStatus(): int
    {
        return $this->runningStatus;
    }

    public function setRunningStatus(int $value): static
    {
        $this->runningStatus = $value;
        return $this;
    }
}
