<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "varient_view" table
 */
#[Entity]
#[Table(name: "varient_view")]
class VarientView extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $grp;

    #[Id]
    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    #[GeneratedValue]
    private ?int $sGrp;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(name: "code_validation", type: "string", nullable: true)]
    private ?string $codeValidation;

    #[Column(type: "string")]
    private string $no;

    #[Column(name: "no_text", type: "string", nullable: true)]
    private ?string $noText;

    #[Column(type: "string", nullable: true)]
    private ?string $partner;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $uid;

    public function __construct(int $id, ?int $sGrp)
    {
        $this->id = $id;
        $this->sGrp = $sGrp;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getCodeValidation(): ?string
    {
        return HtmlDecode($this->codeValidation);
    }

    public function setCodeValidation(?string $value): static
    {
        $this->codeValidation = RemoveXss($value);
        return $this;
    }

    public function getNo(): string
    {
        return HtmlDecode($this->no);
    }

    public function setNo(string $value): static
    {
        $this->no = RemoveXss($value);
        return $this;
    }

    public function getNoText(): ?string
    {
        return HtmlDecode($this->noText);
    }

    public function setNoText(?string $value): static
    {
        $this->noText = RemoveXss($value);
        return $this;
    }

    public function getPartner(): ?string
    {
        return HtmlDecode($this->partner);
    }

    public function setPartner(?string $value): static
    {
        $this->partner = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
