<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "user" table
 */
#[Entity]
#[Table(name: "user")]
class User extends AbstractEntity
{
    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $mobile;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Column(type: "string", nullable: true)]
    private ?string $password;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string")]
    private string $email;

    #[Column(name: "gst_number", type: "string", nullable: true)]
    private ?string $gstNumber;

    #[Column(type: "string")]
    private string $category;

    #[Column(name: "last_login", type: "datetime", nullable: true)]
    private ?DateTime $lastLogin;

    #[Column(name: "reg_date", type: "datetime", nullable: true)]
    private ?DateTime $regDate;

    #[Column(name: "reg_device", type: "integer", nullable: true)]
    private ?int $regDevice;

    #[Column(name: "app_version", type: "integer", nullable: true)]
    private ?int $appVersion;

    #[Column(name: "device_id", type: "string", nullable: true)]
    private ?string $deviceId;

    #[Column(name: "device_token_id", type: "string", nullable: true)]
    private ?string $deviceTokenId;

    #[Column(name: "cart_number", type: "integer", nullable: true)]
    private ?int $cartNumber;

    #[Column(type: "string", nullable: true)]
    private ?string $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "max_discount", type: "decimal")]
    private string $maxDiscount;

    public function __construct()
    {
        $this->appVersion = 0;
        $this->status = "0";
        $this->operator = 0;
        $this->maxDiscount = "0.00";
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getUserName(): ?string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(?string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getPassword(): ?string
    {
        return HtmlDecode($this->password);
    }

    public function setPassword(?string $value): static
    {
        $this->password = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getEmail(): string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getGstNumber(): ?string
    {
        return HtmlDecode($this->gstNumber);
    }

    public function setGstNumber(?string $value): static
    {
        $this->gstNumber = RemoveXss($value);
        return $this;
    }

    public function getCategory(): string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getLastLogin(): ?DateTime
    {
        return $this->lastLogin;
    }

    public function setLastLogin(?DateTime $value): static
    {
        $this->lastLogin = $value;
        return $this;
    }

    public function getRegDate(): ?DateTime
    {
        return $this->regDate;
    }

    public function setRegDate(?DateTime $value): static
    {
        $this->regDate = $value;
        return $this;
    }

    public function getRegDevice(): ?int
    {
        return $this->regDevice;
    }

    public function setRegDevice(?int $value): static
    {
        $this->regDevice = $value;
        return $this;
    }

    public function getAppVersion(): ?int
    {
        return $this->appVersion;
    }

    public function setAppVersion(?int $value): static
    {
        $this->appVersion = $value;
        return $this;
    }

    public function getDeviceId(): ?string
    {
        return HtmlDecode($this->deviceId);
    }

    public function setDeviceId(?string $value): static
    {
        $this->deviceId = RemoveXss($value);
        return $this;
    }

    public function getDeviceTokenId(): ?string
    {
        return HtmlDecode($this->deviceTokenId);
    }

    public function setDeviceTokenId(?string $value): static
    {
        $this->deviceTokenId = RemoveXss($value);
        return $this;
    }

    public function getCartNumber(): ?int
    {
        return $this->cartNumber;
    }

    public function setCartNumber(?int $value): static
    {
        $this->cartNumber = $value;
        return $this;
    }

    public function getStatus(): ?string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(?string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMaxDiscount(): string
    {
        return $this->maxDiscount;
    }

    public function setMaxDiscount(string $value): static
    {
        $this->maxDiscount = $value;
        return $this;
    }
}
