<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "update_old_payment" table
 */
#[Entity]
#[Table(name: "update_old_payment")]
class UpdateOldPayment extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(type: "smallint", nullable: true)]
    private ?int $process;

    #[Column(name: "old_payment_plan", type: "smallint", nullable: true)]
    private ?int $oldPaymentPlan;

    #[Column(name: "old_material_payment_plan", type: "smallint", nullable: true)]
    private ?int $oldMaterialPaymentPlan;

    #[Column(name: "cutoff_date", type: "datetime", nullable: true)]
    private ?DateTime $cutoffDate;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "`update`", options: ["name" => "update"], type: "string", nullable: true)]
    private ?string $update;

    public function __construct()
    {
        $this->type = 0;
        $this->design = (isset($_COOKIE["desid"]))? $_COOKIE["desid"]:'';
        $this->ref = (isset($_COOKIE["refid"]))? $_COOKIE["refid"]:'';
        $this->process = (isset($_COOKIE["pridnew"]))? $_COOKIE["pridnew"]:'';
        $this->operator = 0;
        $this->update = "Update..";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getProcess(): ?int
    {
        return $this->process;
    }

    public function setProcess(?int $value): static
    {
        $this->process = $value;
        return $this;
    }

    public function getOldPaymentPlan(): ?int
    {
        return $this->oldPaymentPlan;
    }

    public function setOldPaymentPlan(?int $value): static
    {
        $this->oldPaymentPlan = $value;
        return $this;
    }

    public function getOldMaterialPaymentPlan(): ?int
    {
        return $this->oldMaterialPaymentPlan;
    }

    public function setOldMaterialPaymentPlan(?int $value): static
    {
        $this->oldMaterialPaymentPlan = $value;
        return $this;
    }

    public function getCutoffDate(): ?DateTime
    {
        return $this->cutoffDate;
    }

    public function setCutoffDate(?DateTime $value): static
    {
        $this->cutoffDate = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUpdate(): ?string
    {
        return HtmlDecode($this->update);
    }

    public function setUpdate(?string $value): static
    {
        $this->update = RemoveXss($value);
        return $this;
    }
}
