<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "tmp_notes_bc" table
 */
#[Entity]
#[Table(name: "tmp_notes_bc")]
class TmpNotesBc extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $buyer;

    #[Column(type: "string")]
    private string $design;

    #[Column(type: "string")]
    private string $size;

    #[Column(type: "text")]
    private string $barcode;

    #[Column(name: "delivery_date_new", type: "datetime", nullable: true)]
    private ?DateTime $deliveryDateNew;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyer(): int
    {
        return $this->buyer;
    }

    public function setBuyer(int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getDesign(): string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getDeliveryDateNew(): ?DateTime
    {
        return $this->deliveryDateNew;
    }

    public function setDeliveryDateNew(?DateTime $value): static
    {
        $this->deliveryDateNew = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
