<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "test_report_head" table
 */
#[Entity]
#[Table(name: "test_report_head")]
class TestReportHead extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(name: "d_01", type: "string")]
    private string $d01;

    #[Column(name: "d_02", type: "string")]
    private string $d02;

    #[Column(name: "d_03", type: "string")]
    private string $d03;

    #[Column(name: "d_04", type: "string")]
    private string $d04;

    #[Column(name: "d_05", type: "string")]
    private string $d05;

    #[Column(name: "d_06", type: "string")]
    private string $d06;

    #[Column(name: "d_07", type: "string")]
    private string $d07;

    #[Column(name: "d_08", type: "string")]
    private string $d08;

    #[Column(name: "d_09", type: "string")]
    private string $d09;

    #[Column(name: "d_10", type: "string")]
    private string $d10;

    #[Column(name: "d_11", type: "string")]
    private string $d11;

    #[Column(name: "d_12", type: "string")]
    private string $d12;

    #[Column(name: "d_13", type: "string")]
    private string $d13;

    #[Column(name: "d_14", type: "string")]
    private string $d14;

    #[Column(name: "d_15", type: "string")]
    private string $d15;

    #[Column(name: "d_16", type: "string")]
    private string $d16;

    #[Column(name: "d_17", type: "string")]
    private string $d17;

    #[Column(name: "d_18", type: "string")]
    private string $d18;

    #[Column(name: "d_19", type: "string")]
    private string $d19;

    #[Column(name: "d_20", type: "string")]
    private string $d20;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getD01(): string
    {
        return HtmlDecode($this->d01);
    }

    public function setD01(string $value): static
    {
        $this->d01 = RemoveXss($value);
        return $this;
    }

    public function getD02(): string
    {
        return HtmlDecode($this->d02);
    }

    public function setD02(string $value): static
    {
        $this->d02 = RemoveXss($value);
        return $this;
    }

    public function getD03(): string
    {
        return HtmlDecode($this->d03);
    }

    public function setD03(string $value): static
    {
        $this->d03 = RemoveXss($value);
        return $this;
    }

    public function getD04(): string
    {
        return HtmlDecode($this->d04);
    }

    public function setD04(string $value): static
    {
        $this->d04 = RemoveXss($value);
        return $this;
    }

    public function getD05(): string
    {
        return HtmlDecode($this->d05);
    }

    public function setD05(string $value): static
    {
        $this->d05 = RemoveXss($value);
        return $this;
    }

    public function getD06(): string
    {
        return HtmlDecode($this->d06);
    }

    public function setD06(string $value): static
    {
        $this->d06 = RemoveXss($value);
        return $this;
    }

    public function getD07(): string
    {
        return HtmlDecode($this->d07);
    }

    public function setD07(string $value): static
    {
        $this->d07 = RemoveXss($value);
        return $this;
    }

    public function getD08(): string
    {
        return HtmlDecode($this->d08);
    }

    public function setD08(string $value): static
    {
        $this->d08 = RemoveXss($value);
        return $this;
    }

    public function getD09(): string
    {
        return HtmlDecode($this->d09);
    }

    public function setD09(string $value): static
    {
        $this->d09 = RemoveXss($value);
        return $this;
    }

    public function getD10(): string
    {
        return HtmlDecode($this->d10);
    }

    public function setD10(string $value): static
    {
        $this->d10 = RemoveXss($value);
        return $this;
    }

    public function getD11(): string
    {
        return HtmlDecode($this->d11);
    }

    public function setD11(string $value): static
    {
        $this->d11 = RemoveXss($value);
        return $this;
    }

    public function getD12(): string
    {
        return HtmlDecode($this->d12);
    }

    public function setD12(string $value): static
    {
        $this->d12 = RemoveXss($value);
        return $this;
    }

    public function getD13(): string
    {
        return HtmlDecode($this->d13);
    }

    public function setD13(string $value): static
    {
        $this->d13 = RemoveXss($value);
        return $this;
    }

    public function getD14(): string
    {
        return HtmlDecode($this->d14);
    }

    public function setD14(string $value): static
    {
        $this->d14 = RemoveXss($value);
        return $this;
    }

    public function getD15(): string
    {
        return HtmlDecode($this->d15);
    }

    public function setD15(string $value): static
    {
        $this->d15 = RemoveXss($value);
        return $this;
    }

    public function getD16(): string
    {
        return HtmlDecode($this->d16);
    }

    public function setD16(string $value): static
    {
        $this->d16 = RemoveXss($value);
        return $this;
    }

    public function getD17(): string
    {
        return HtmlDecode($this->d17);
    }

    public function setD17(string $value): static
    {
        $this->d17 = RemoveXss($value);
        return $this;
    }

    public function getD18(): string
    {
        return HtmlDecode($this->d18);
    }

    public function setD18(string $value): static
    {
        $this->d18 = RemoveXss($value);
        return $this;
    }

    public function getD19(): string
    {
        return HtmlDecode($this->d19);
    }

    public function setD19(string $value): static
    {
        $this->d19 = RemoveXss($value);
        return $this;
    }

    public function getD20(): string
    {
        return HtmlDecode($this->d20);
    }

    public function setD20(string $value): static
    {
        $this->d20 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
