<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "test_report" table
 */
#[Entity]
#[Table(name: "test_report")]
class TestReport extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $ref;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(name: "d_01", type: "float")]
    private float $d01;

    #[Column(name: "d_02", type: "float")]
    private float $d02;

    #[Column(name: "d_03", type: "float")]
    private float $d03;

    #[Column(name: "d_04", type: "float")]
    private float $d04;

    #[Column(name: "d_05", type: "float")]
    private float $d05;

    #[Column(name: "d_06", type: "float")]
    private float $d06;

    #[Column(name: "d_07", type: "float")]
    private float $d07;

    #[Column(name: "d_08", type: "float")]
    private float $d08;

    #[Column(name: "d_09", type: "float")]
    private float $d09;

    #[Column(name: "d_10", type: "float")]
    private float $d10;

    #[Column(name: "d_11", type: "float")]
    private float $d11;

    #[Column(name: "d_12", type: "float")]
    private float $d12;

    #[Column(name: "d_13", type: "float")]
    private float $d13;

    #[Column(name: "d_14", type: "float")]
    private float $d14;

    #[Column(name: "d_15", type: "float")]
    private float $d15;

    #[Column(name: "d_16", type: "float")]
    private float $d16;

    #[Column(name: "d_17", type: "float")]
    private float $d17;

    #[Column(name: "d_18", type: "float")]
    private float $d18;

    #[Column(name: "d_19", type: "float")]
    private float $d19;

    #[Column(name: "d_20", type: "float")]
    private float $d20;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): int
    {
        return $this->ref;
    }

    public function setRef(int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getD01(): float
    {
        return $this->d01;
    }

    public function setD01(float $value): static
    {
        $this->d01 = $value;
        return $this;
    }

    public function getD02(): float
    {
        return $this->d02;
    }

    public function setD02(float $value): static
    {
        $this->d02 = $value;
        return $this;
    }

    public function getD03(): float
    {
        return $this->d03;
    }

    public function setD03(float $value): static
    {
        $this->d03 = $value;
        return $this;
    }

    public function getD04(): float
    {
        return $this->d04;
    }

    public function setD04(float $value): static
    {
        $this->d04 = $value;
        return $this;
    }

    public function getD05(): float
    {
        return $this->d05;
    }

    public function setD05(float $value): static
    {
        $this->d05 = $value;
        return $this;
    }

    public function getD06(): float
    {
        return $this->d06;
    }

    public function setD06(float $value): static
    {
        $this->d06 = $value;
        return $this;
    }

    public function getD07(): float
    {
        return $this->d07;
    }

    public function setD07(float $value): static
    {
        $this->d07 = $value;
        return $this;
    }

    public function getD08(): float
    {
        return $this->d08;
    }

    public function setD08(float $value): static
    {
        $this->d08 = $value;
        return $this;
    }

    public function getD09(): float
    {
        return $this->d09;
    }

    public function setD09(float $value): static
    {
        $this->d09 = $value;
        return $this;
    }

    public function getD10(): float
    {
        return $this->d10;
    }

    public function setD10(float $value): static
    {
        $this->d10 = $value;
        return $this;
    }

    public function getD11(): float
    {
        return $this->d11;
    }

    public function setD11(float $value): static
    {
        $this->d11 = $value;
        return $this;
    }

    public function getD12(): float
    {
        return $this->d12;
    }

    public function setD12(float $value): static
    {
        $this->d12 = $value;
        return $this;
    }

    public function getD13(): float
    {
        return $this->d13;
    }

    public function setD13(float $value): static
    {
        $this->d13 = $value;
        return $this;
    }

    public function getD14(): float
    {
        return $this->d14;
    }

    public function setD14(float $value): static
    {
        $this->d14 = $value;
        return $this;
    }

    public function getD15(): float
    {
        return $this->d15;
    }

    public function setD15(float $value): static
    {
        $this->d15 = $value;
        return $this;
    }

    public function getD16(): float
    {
        return $this->d16;
    }

    public function setD16(float $value): static
    {
        $this->d16 = $value;
        return $this;
    }

    public function getD17(): float
    {
        return $this->d17;
    }

    public function setD17(float $value): static
    {
        $this->d17 = $value;
        return $this;
    }

    public function getD18(): float
    {
        return $this->d18;
    }

    public function setD18(float $value): static
    {
        $this->d18 = $value;
        return $this;
    }

    public function getD19(): float
    {
        return $this->d19;
    }

    public function setD19(float $value): static
    {
        $this->d19 = $value;
        return $this;
    }

    public function getD20(): float
    {
        return $this->d20;
    }

    public function setD20(float $value): static
    {
        $this->d20 = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
