<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_tyre_maintenance" table
 */
#[Entity]
#[Table(name: "t_tyre_maintenance")]
class TTyreMaintenance extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_no", type: "smallint")]
    private int $vehicleNo;

    #[Column(type: "smallint")]
    private int $driver;

    #[Column(name: "tyre_id", type: "smallint")]
    private int $tyreId;

    #[Column(type: "smallint")]
    private int $type;

    #[Column(type: "smallint", nullable: true)]
    private ?int $no;

    #[Column(name: "old_puncture", type: "smallint")]
    private int $oldPuncture;

    #[Column(name: "puncture_date", type: "datetime")]
    private DateTime $punctureDate;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->type = 1;
        $this->no = 1;
        $this->oldPuncture = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleNo(): int
    {
        return $this->vehicleNo;
    }

    public function setVehicleNo(int $value): static
    {
        $this->vehicleNo = $value;
        return $this;
    }

    public function getDriver(): int
    {
        return $this->driver;
    }

    public function setDriver(int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getTyreId(): int
    {
        return $this->tyreId;
    }

    public function setTyreId(int $value): static
    {
        $this->tyreId = $value;
        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $value): static
    {
        $this->type = $value;
        return $this;
    }

    public function getNo(): ?int
    {
        return $this->no;
    }

    public function setNo(?int $value): static
    {
        $this->no = $value;
        return $this;
    }

    public function getOldPuncture(): int
    {
        return $this->oldPuncture;
    }

    public function setOldPuncture(int $value): static
    {
        $this->oldPuncture = $value;
        return $this;
    }

    public function getPunctureDate(): DateTime
    {
        return $this->punctureDate;
    }

    public function setPunctureDate(DateTime $value): static
    {
        $this->punctureDate = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
