<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_tyre_info" table
 */
#[Entity]
#[Table(name: "t_tyre_info")]
class TTyreInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_no", type: "smallint")]
    private int $vehicleNo;

    #[Column(type: "smallint")]
    private int $head;

    #[Column(name: "sub_head", type: "smallint", nullable: true)]
    private ?int $subHead;

    #[Column(name: "s_no", type: "string", nullable: true)]
    private ?string $sNo;

    #[Column(type: "integer")]
    private int $km;

    #[Column(name: "life_km", type: "integer")]
    private int $lifeKm;

    #[Column(name: "recycle_after_km", type: "integer")]
    private int $recycleAfterKm;

    #[Column(name: "next_km", type: "integer")]
    private int $nextKm;

    #[Column(name: "recycle_next_km", type: "integer", nullable: true)]
    private ?int $recycleNextKm;

    #[Column(type: "smallint")]
    private int $puncture;

    #[Column(name: "current_km", type: "integer")]
    private int $currentKm;

    #[Column(name: "remaining_km", type: "integer")]
    private int $remainingKm;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->recycleAfterKm = 0;
        $this->recycleNextKm = 0;
        $this->puncture = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleNo(): int
    {
        return $this->vehicleNo;
    }

    public function setVehicleNo(int $value): static
    {
        $this->vehicleNo = $value;
        return $this;
    }

    public function getHead(): int
    {
        return $this->head;
    }

    public function setHead(int $value): static
    {
        $this->head = $value;
        return $this;
    }

    public function getSubHead(): ?int
    {
        return $this->subHead;
    }

    public function setSubHead(?int $value): static
    {
        $this->subHead = $value;
        return $this;
    }

    public function getSNo(): ?string
    {
        return HtmlDecode($this->sNo);
    }

    public function setSNo(?string $value): static
    {
        $this->sNo = RemoveXss($value);
        return $this;
    }

    public function getKm(): int
    {
        return $this->km;
    }

    public function setKm(int $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getLifeKm(): int
    {
        return $this->lifeKm;
    }

    public function setLifeKm(int $value): static
    {
        $this->lifeKm = $value;
        return $this;
    }

    public function getRecycleAfterKm(): int
    {
        return $this->recycleAfterKm;
    }

    public function setRecycleAfterKm(int $value): static
    {
        $this->recycleAfterKm = $value;
        return $this;
    }

    public function getNextKm(): int
    {
        return $this->nextKm;
    }

    public function setNextKm(int $value): static
    {
        $this->nextKm = $value;
        return $this;
    }

    public function getRecycleNextKm(): ?int
    {
        return $this->recycleNextKm;
    }

    public function setRecycleNextKm(?int $value): static
    {
        $this->recycleNextKm = $value;
        return $this;
    }

    public function getPuncture(): int
    {
        return $this->puncture;
    }

    public function setPuncture(int $value): static
    {
        $this->puncture = $value;
        return $this;
    }

    public function getCurrentKm(): int
    {
        return $this->currentKm;
    }

    public function setCurrentKm(int $value): static
    {
        $this->currentKm = $value;
        return $this;
    }

    public function getRemainingKm(): int
    {
        return $this->remainingKm;
    }

    public function setRemainingKm(int $value): static
    {
        $this->remainingKm = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
