<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_start" table
 */
#[Entity]
#[Table(name: "t_trip_start")]
class TTripStart extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_type", type: "smallint")]
    private int $vehicleType;

    #[Column(type: "smallint")]
    private int $vehicle;

    #[Column(type: "smallint")]
    private int $route;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(name: "vehicle_freight_type", type: "smallint")]
    private int $vehicleFreightType;

    #[Column(name: "vehicle_freight_amount", type: "decimal")]
    private string $vehicleFreightAmount;

    #[Column(type: "string")]
    private string $material;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal")]
    private string $40;

    #[Column(type: "smallint")]
    private int $buyer;

    #[Column(type: "smallint", nullable: true)]
    private ?int $agent;

    #[Column(type: "decimal")]
    private string $comm;

    #[Column(name: "load_date", type: "datetime")]
    private DateTime $loadDate;

    #[Column(name: "load_weight", type: "smallint", nullable: true)]
    private ?int $loadWeight;

    #[Column(name: "load_km", type: "integer")]
    private int $loadKm;

    #[Column(name: "gst_percent", type: "decimal")]
    private string $gstPercent;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(type: "text", nullable: true)]
    private ?string $remarks;

    #[Column(name: "vehicle_freight_comm", type: "decimal")]
    private string $vehicleFreightComm;

    #[Column(name: "freight_type", type: "smallint")]
    private int $freightType;

    #[Column(type: "decimal")]
    private string $freight;

    public function __construct()
    {
        $this->vehicleType = 1;
        $this->reportsTo = 0;
        $this->vehicleFreightType = 0;
        $this->comm = "0.00";
        $this->gstPercent = "0.00";
        $this->vehicleFreightComm = "0.00";
        $this->freightType = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleType(): int
    {
        return $this->vehicleType;
    }

    public function setVehicleType(int $value): static
    {
        $this->vehicleType = $value;
        return $this;
    }

    public function getVehicle(): int
    {
        return $this->vehicle;
    }

    public function setVehicle(int $value): static
    {
        $this->vehicle = $value;
        return $this;
    }

    public function getRoute(): int
    {
        return $this->route;
    }

    public function setRoute(int $value): static
    {
        $this->route = $value;
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getVehicleFreightType(): int
    {
        return $this->vehicleFreightType;
    }

    public function setVehicleFreightType(int $value): static
    {
        $this->vehicleFreightType = $value;
        return $this;
    }

    public function getVehicleFreightAmount(): string
    {
        return $this->vehicleFreightAmount;
    }

    public function setVehicleFreightAmount(string $value): static
    {
        $this->vehicleFreightAmount = $value;
        return $this;
    }

    public function getMaterial(): string
    {
        return HtmlDecode($this->material);
    }

    public function setMaterial(string $value): static
    {
        $this->material = RemoveXss($value);
        return $this;
    }

    public function get40(): string
    {
        return $this->40;
    }

    public function set40(string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getBuyer(): int
    {
        return $this->buyer;
    }

    public function setBuyer(int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getComm(): string
    {
        return $this->comm;
    }

    public function setComm(string $value): static
    {
        $this->comm = $value;
        return $this;
    }

    public function getLoadDate(): DateTime
    {
        return $this->loadDate;
    }

    public function setLoadDate(DateTime $value): static
    {
        $this->loadDate = $value;
        return $this;
    }

    public function getLoadWeight(): ?int
    {
        return $this->loadWeight;
    }

    public function setLoadWeight(?int $value): static
    {
        $this->loadWeight = $value;
        return $this;
    }

    public function getLoadKm(): int
    {
        return $this->loadKm;
    }

    public function setLoadKm(int $value): static
    {
        $this->loadKm = $value;
        return $this;
    }

    public function getGstPercent(): string
    {
        return $this->gstPercent;
    }

    public function setGstPercent(string $value): static
    {
        $this->gstPercent = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getVehicleFreightComm(): string
    {
        return $this->vehicleFreightComm;
    }

    public function setVehicleFreightComm(string $value): static
    {
        $this->vehicleFreightComm = $value;
        return $this;
    }

    public function getFreightType(): int
    {
        return $this->freightType;
    }

    public function setFreightType(int $value): static
    {
        $this->freightType = $value;
        return $this;
    }

    public function getFreight(): string
    {
        return $this->freight;
    }

    public function setFreight(string $value): static
    {
        $this->freight = $value;
        return $this;
    }
}
