<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_loadslip" table
 */
#[Entity]
#[Table(name: "t_trip_loadslip")]
class TTripLoadslip extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_type", type: "smallint")]
    private int $vehicleType;

    #[Column(type: "smallint")]
    private int $vehicle;

    #[Column(type: "smallint")]
    private int $route;

    #[Column(name: "route_name", type: "string", nullable: true)]
    private ?string $routeName;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(name: "driver_name", type: "string", nullable: true)]
    private ?string $driverName;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(type: "smallint")]
    private int $buyer;

    #[Column(name: "b_consignor", type: "smallint", nullable: true)]
    private ?int $bConsignor;

    #[Column(name: "b_consignee", type: "smallint", nullable: true)]
    private ?int $bConsignee;

    #[Column(type: "smallint", nullable: true)]
    private ?int $agent;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->vehicleType = 1;
        $this->reportsTo = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleType(): int
    {
        return $this->vehicleType;
    }

    public function setVehicleType(int $value): static
    {
        $this->vehicleType = $value;
        return $this;
    }

    public function getVehicle(): int
    {
        return $this->vehicle;
    }

    public function setVehicle(int $value): static
    {
        $this->vehicle = $value;
        return $this;
    }

    public function getRoute(): int
    {
        return $this->route;
    }

    public function setRoute(int $value): static
    {
        $this->route = $value;
        return $this;
    }

    public function getRouteName(): ?string
    {
        return HtmlDecode($this->routeName);
    }

    public function setRouteName(?string $value): static
    {
        $this->routeName = RemoveXss($value);
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getDriverName(): ?string
    {
        return HtmlDecode($this->driverName);
    }

    public function setDriverName(?string $value): static
    {
        $this->driverName = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getBuyer(): int
    {
        return $this->buyer;
    }

    public function setBuyer(int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getBConsignor(): ?int
    {
        return $this->bConsignor;
    }

    public function setBConsignor(?int $value): static
    {
        $this->bConsignor = $value;
        return $this;
    }

    public function getBConsignee(): ?int
    {
        return $this->bConsignee;
    }

    public function setBConsignee(?int $value): static
    {
        $this->bConsignee = $value;
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
