<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_info_d_unload" table
 */
#[Entity]
#[Table(name: "t_trip_info_d_unload")]
class TTripInfoDUnload extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "load_date", type: "datetime")]
    private DateTime $loadDate;

    #[Column(name: "trip_info", type: "smallint")]
    #[GeneratedValue]
    private int $tripInfo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(name: "unload_km", type: "integer")]
    private int $unloadKm;

    #[Column(name: "load_weight", type: "smallint", nullable: true)]
    private ?int $loadWeight;

    #[Column(name: "unload_weight", type: "smallint", nullable: true)]
    private ?int $unloadWeight;

    #[Column(name: "unload_date", type: "datetime", nullable: true)]
    private ?DateTime $unloadDate;

    #[Column(name: "ded_det", type: "decimal")]
    private string $dedDet;

    #[Column(name: "ded_det_remarks", type: "string", nullable: true)]
    private ?string $dedDetRemarks;

    #[Column(name: "fasttag_cl_balance", type: "decimal", nullable: true)]
    private ?string $fasttagClBalance;

    #[Column(name: "delivery_receipt", type: "string", nullable: true)]
    private ?string $deliveryReceipt;

    #[Column(name: "delivery_pod", type: "string", nullable: true)]
    private ?string $deliveryPod;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->driver = 0;
        $this->loadWeight = 0;
        $this->unloadWeight = 0;
        $this->dedDet = "0.00";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLoadDate(): DateTime
    {
        return $this->loadDate;
    }

    public function setLoadDate(DateTime $value): static
    {
        $this->loadDate = $value;
        return $this;
    }

    public function getTripInfo(): int
    {
        return $this->tripInfo;
    }

    public function setTripInfo(int $value): static
    {
        $this->tripInfo = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getUnloadKm(): int
    {
        return $this->unloadKm;
    }

    public function setUnloadKm(int $value): static
    {
        $this->unloadKm = $value;
        return $this;
    }

    public function getLoadWeight(): ?int
    {
        return $this->loadWeight;
    }

    public function setLoadWeight(?int $value): static
    {
        $this->loadWeight = $value;
        return $this;
    }

    public function getUnloadWeight(): ?int
    {
        return $this->unloadWeight;
    }

    public function setUnloadWeight(?int $value): static
    {
        $this->unloadWeight = $value;
        return $this;
    }

    public function getUnloadDate(): ?DateTime
    {
        return $this->unloadDate;
    }

    public function setUnloadDate(?DateTime $value): static
    {
        $this->unloadDate = $value;
        return $this;
    }

    public function getDedDet(): string
    {
        return $this->dedDet;
    }

    public function setDedDet(string $value): static
    {
        $this->dedDet = $value;
        return $this;
    }

    public function getDedDetRemarks(): ?string
    {
        return HtmlDecode($this->dedDetRemarks);
    }

    public function setDedDetRemarks(?string $value): static
    {
        $this->dedDetRemarks = RemoveXss($value);
        return $this;
    }

    public function getFasttagClBalance(): ?string
    {
        return $this->fasttagClBalance;
    }

    public function setFasttagClBalance(?string $value): static
    {
        $this->fasttagClBalance = $value;
        return $this;
    }

    public function getDeliveryReceipt(): ?string
    {
        return HtmlDecode($this->deliveryReceipt);
    }

    public function setDeliveryReceipt(?string $value): static
    {
        $this->deliveryReceipt = RemoveXss($value);
        return $this;
    }

    public function getDeliveryPod(): ?string
    {
        return HtmlDecode($this->deliveryPod);
    }

    public function setDeliveryPod(?string $value): static
    {
        $this->deliveryPod = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
