<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_info_d" table
 */
#[Entity]
#[Table(name: "t_trip_info_d")]
class TTripInfoD extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $route;

    #[Column(name: "load_km", type: "integer")]
    private int $loadKm;

    #[Column(name: "load_weight", type: "smallint", nullable: true)]
    private ?int $loadWeight;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "smallint")]
    private int $vehicle;

    public function __construct()
    {
        $this->driver = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRoute(): ?string
    {
        return HtmlDecode($this->route);
    }

    public function setRoute(?string $value): static
    {
        $this->route = RemoveXss($value);
        return $this;
    }

    public function getLoadKm(): int
    {
        return $this->loadKm;
    }

    public function setLoadKm(int $value): static
    {
        $this->loadKm = $value;
        return $this;
    }

    public function getLoadWeight(): ?int
    {
        return $this->loadWeight;
    }

    public function setLoadWeight(?int $value): static
    {
        $this->loadWeight = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getVehicle(): int
    {
        return $this->vehicle;
    }

    public function setVehicle(int $value): static
    {
        $this->vehicle = $value;
        return $this;
    }
}
