<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_info" table
 */
#[Entity]
#[Table(name: "t_trip_info")]
class TTripInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_type", type: "smallint")]
    private int $vehicleType;

    #[Column(type: "smallint")]
    private int $vehicle;

    #[Column(type: "smallint")]
    private int $route;

    #[Column(name: "route_name", type: "string", nullable: true)]
    private ?string $routeName;

    #[Column(name: "reports_to", type: "smallint", nullable: true)]
    private ?int $reportsTo;

    #[Column(type: "smallint")]
    private int $buyer;

    #[Column(name: "b_consignor", type: "smallint", nullable: true)]
    private ?int $bConsignor;

    #[Column(name: "b_consignee", type: "smallint", nullable: true)]
    private ?int $bConsignee;

    #[Column(name: "load_date", type: "datetime")]
    private DateTime $loadDate;

    #[Column(name: "load_weight", type: "smallint", nullable: true)]
    private ?int $loadWeight;

    #[Column(name: "unload_date", type: "datetime", nullable: true)]
    private ?DateTime $unloadDate;

    #[Column(name: "unload_weight", type: "smallint", nullable: true)]
    private ?int $unloadWeight;

    #[Column(name: "invoice_no", type: "smallint")]
    private int $invoiceNo;

    #[Column(name: "invoice_date", type: "date", nullable: true)]
    private ?DateTime $invoiceDate;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(name: "delivery_pod", type: "string", nullable: true)]
    private ?string $deliveryPod;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "integer")]
    private int $days;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(name: "driver_name", type: "string", nullable: true)]
    private ?string $driverName;

    #[Column(type: "smallint", nullable: true)]
    private ?int $agent;

    #[Column(type: "decimal")]
    private string $comm;

    #[Column(type: "string")]
    private string $material;

    #[Column(name: "packing_type", type: "string")]
    private string $packingType;

    #[Column(name: "m_hsn", type: "string", nullable: true)]
    private ?string $mHsn;

    #[Column(name: "`@`", options: ["name" => "@"], type: "decimal")]
    private string $40;

    #[Column(name: "lr_no", type: "string", nullable: true)]
    private ?string $lrNo;

    #[Column(type: "decimal", nullable: true)]
    private ?string $km;

    #[Column(name: "freight_type", type: "smallint")]
    private int $freightType;

    #[Column(type: "decimal")]
    private string $freight;

    #[Column(name: "ded_det", type: "decimal")]
    private string $dedDet;

    #[Column(name: "ded_det_remarks", type: "string", nullable: true)]
    private ?string $dedDetRemarks;

    #[Column(name: "gst_percent", type: "decimal")]
    private string $gstPercent;

    #[Column(name: "gst_amount", type: "decimal", nullable: true)]
    private ?string $gstAmount;

    #[Column(name: "final_amount", type: "decimal", nullable: true)]
    private ?string $finalAmount;

    #[Column(name: "load_km", type: "integer")]
    private int $loadKm;

    #[Column(name: "unload_km", type: "integer")]
    private int $unloadKm;

    #[Column(name: "delivery_receipt", type: "string", nullable: true)]
    private ?string $deliveryReceipt;

    #[Column(name: "delivery_docket", type: "string", nullable: true)]
    private ?string $deliveryDocket;

    #[Column(name: "diesal_op_b", type: "decimal")]
    private string $diesalOpB;

    #[Column(name: "diesal_required", type: "decimal", nullable: true)]
    private ?string $diesalRequired;

    #[Column(name: "diesal_fill", type: "decimal")]
    private string $diesalFill;

    #[Column(name: "diesal_amount", type: "decimal")]
    private string $diesalAmount;

    #[Column(name: "diesal_cl_balance", type: "decimal")]
    private string $diesalClBalance;

    #[Column(name: "vehicle_average", type: "decimal")]
    private string $vehicleAverage;

    #[Column(name: "cash_required", type: "decimal", nullable: true)]
    private ?string $cashRequired;

    #[Column(name: "cash_op_b", type: "decimal")]
    private string $cashOpB;

    #[Column(name: "cash_paid", type: "decimal")]
    private string $cashPaid;

    #[Column(name: "cash_expenses", type: "decimal")]
    private string $cashExpenses;

    #[Column(name: "cash_cl_balance", type: "decimal")]
    private string $cashClBalance;

    #[Column(name: "fasttag_op_b", type: "decimal", nullable: true)]
    private ?string $fasttagOpB;

    #[Column(name: "fasttag_recharge", type: "decimal", nullable: true)]
    private ?string $fasttagRecharge;

    #[Column(name: "fasttag_expenses", type: "decimal", nullable: true)]
    private ?string $fasttagExpenses;

    #[Column(name: "toll_expenses_cash", type: "decimal", nullable: true)]
    private ?string $tollExpensesCash;

    #[Column(name: "fasttag_cl_balance", type: "decimal", nullable: true)]
    private ?string $fasttagClBalance;

    #[Column(type: "text", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "integer")]
    private int $consignor;

    #[Column(name: "vehicle_freight_comm", type: "decimal")]
    private string $vehicleFreightComm;

    #[Column(name: "vehicle_freight_type", type: "smallint")]
    private int $vehicleFreightType;

    #[Column(name: "vehicle_freight_amount", type: "decimal")]
    private string $vehicleFreightAmount;

    #[Column(name: "vehicle_freight_final", type: "decimal")]
    private string $vehicleFreightFinal;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "expenses_id", type: "integer")]
    private int $expensesId;

    public function __construct()
    {
        $this->vehicleType = 1;
        $this->reportsTo = 0;
        $this->unloadWeight = 0;
        $this->invoiceNo = 0;
        $this->amount = "0.00";
        $this->deliveryPod = "0";
        $this->status = 0;
        $this->comm = "0.00";
        $this->freightType = 0;
        $this->dedDet = "0.00";
        $this->gstPercent = "0.00";
        $this->gstAmount = "0.00";
        $this->finalAmount = "0.00";
        $this->diesalAmount = "0.00";
        $this->diesalClBalance = "0.00";
        $this->cashExpenses = "0.00";
        $this->cashClBalance = "0.00";
        $this->fasttagOpB = "0.00";
        $this->fasttagRecharge = "0.00";
        $this->fasttagExpenses = "0.00";
        $this->tollExpensesCash = "0.00";
        $this->vehicleFreightComm = "0.00";
        $this->vehicleFreightType = 0;
        $this->vehicleFreightFinal = "0.00";
        $this->operator = 0;
        $this->expensesId = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleType(): int
    {
        return $this->vehicleType;
    }

    public function setVehicleType(int $value): static
    {
        $this->vehicleType = $value;
        return $this;
    }

    public function getVehicle(): int
    {
        return $this->vehicle;
    }

    public function setVehicle(int $value): static
    {
        $this->vehicle = $value;
        return $this;
    }

    public function getRoute(): int
    {
        return $this->route;
    }

    public function setRoute(int $value): static
    {
        $this->route = $value;
        return $this;
    }

    public function getRouteName(): ?string
    {
        return HtmlDecode($this->routeName);
    }

    public function setRouteName(?string $value): static
    {
        $this->routeName = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): ?int
    {
        return $this->reportsTo;
    }

    public function setReportsTo(?int $value): static
    {
        $this->reportsTo = $value;
        return $this;
    }

    public function getBuyer(): int
    {
        return $this->buyer;
    }

    public function setBuyer(int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getBConsignor(): ?int
    {
        return $this->bConsignor;
    }

    public function setBConsignor(?int $value): static
    {
        $this->bConsignor = $value;
        return $this;
    }

    public function getBConsignee(): ?int
    {
        return $this->bConsignee;
    }

    public function setBConsignee(?int $value): static
    {
        $this->bConsignee = $value;
        return $this;
    }

    public function getLoadDate(): DateTime
    {
        return $this->loadDate;
    }

    public function setLoadDate(DateTime $value): static
    {
        $this->loadDate = $value;
        return $this;
    }

    public function getLoadWeight(): ?int
    {
        return $this->loadWeight;
    }

    public function setLoadWeight(?int $value): static
    {
        $this->loadWeight = $value;
        return $this;
    }

    public function getUnloadDate(): ?DateTime
    {
        return $this->unloadDate;
    }

    public function setUnloadDate(?DateTime $value): static
    {
        $this->unloadDate = $value;
        return $this;
    }

    public function getUnloadWeight(): ?int
    {
        return $this->unloadWeight;
    }

    public function setUnloadWeight(?int $value): static
    {
        $this->unloadWeight = $value;
        return $this;
    }

    public function getInvoiceNo(): int
    {
        return $this->invoiceNo;
    }

    public function setInvoiceNo(int $value): static
    {
        $this->invoiceNo = $value;
        return $this;
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?DateTime $value): static
    {
        $this->invoiceDate = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getDeliveryPod(): ?string
    {
        return HtmlDecode($this->deliveryPod);
    }

    public function setDeliveryPod(?string $value): static
    {
        $this->deliveryPod = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getDays(): int
    {
        return $this->days;
    }

    public function setDays(int $value): static
    {
        $this->days = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getDriverName(): ?string
    {
        return HtmlDecode($this->driverName);
    }

    public function setDriverName(?string $value): static
    {
        $this->driverName = RemoveXss($value);
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getComm(): string
    {
        return $this->comm;
    }

    public function setComm(string $value): static
    {
        $this->comm = $value;
        return $this;
    }

    public function getMaterial(): string
    {
        return HtmlDecode($this->material);
    }

    public function setMaterial(string $value): static
    {
        $this->material = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): string
    {
        return HtmlDecode($this->packingType);
    }

    public function setPackingType(string $value): static
    {
        $this->packingType = RemoveXss($value);
        return $this;
    }

    public function getMHsn(): ?string
    {
        return HtmlDecode($this->mHsn);
    }

    public function setMHsn(?string $value): static
    {
        $this->mHsn = RemoveXss($value);
        return $this;
    }

    public function get40(): string
    {
        return $this->40;
    }

    public function set40(string $value): static
    {
        $this->40 = $value;
        return $this;
    }

    public function getLrNo(): ?string
    {
        return HtmlDecode($this->lrNo);
    }

    public function setLrNo(?string $value): static
    {
        $this->lrNo = RemoveXss($value);
        return $this;
    }

    public function getKm(): ?string
    {
        return $this->km;
    }

    public function setKm(?string $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getFreightType(): int
    {
        return $this->freightType;
    }

    public function setFreightType(int $value): static
    {
        $this->freightType = $value;
        return $this;
    }

    public function getFreight(): string
    {
        return $this->freight;
    }

    public function setFreight(string $value): static
    {
        $this->freight = $value;
        return $this;
    }

    public function getDedDet(): string
    {
        return $this->dedDet;
    }

    public function setDedDet(string $value): static
    {
        $this->dedDet = $value;
        return $this;
    }

    public function getDedDetRemarks(): ?string
    {
        return HtmlDecode($this->dedDetRemarks);
    }

    public function setDedDetRemarks(?string $value): static
    {
        $this->dedDetRemarks = RemoveXss($value);
        return $this;
    }

    public function getGstPercent(): string
    {
        return $this->gstPercent;
    }

    public function setGstPercent(string $value): static
    {
        $this->gstPercent = $value;
        return $this;
    }

    public function getGstAmount(): ?string
    {
        return $this->gstAmount;
    }

    public function setGstAmount(?string $value): static
    {
        $this->gstAmount = $value;
        return $this;
    }

    public function getFinalAmount(): ?string
    {
        return $this->finalAmount;
    }

    public function setFinalAmount(?string $value): static
    {
        $this->finalAmount = $value;
        return $this;
    }

    public function getLoadKm(): int
    {
        return $this->loadKm;
    }

    public function setLoadKm(int $value): static
    {
        $this->loadKm = $value;
        return $this;
    }

    public function getUnloadKm(): int
    {
        return $this->unloadKm;
    }

    public function setUnloadKm(int $value): static
    {
        $this->unloadKm = $value;
        return $this;
    }

    public function getDeliveryReceipt(): ?string
    {
        return HtmlDecode($this->deliveryReceipt);
    }

    public function setDeliveryReceipt(?string $value): static
    {
        $this->deliveryReceipt = RemoveXss($value);
        return $this;
    }

    public function getDeliveryDocket(): ?string
    {
        return HtmlDecode($this->deliveryDocket);
    }

    public function setDeliveryDocket(?string $value): static
    {
        $this->deliveryDocket = RemoveXss($value);
        return $this;
    }

    public function getDiesalOpB(): string
    {
        return $this->diesalOpB;
    }

    public function setDiesalOpB(string $value): static
    {
        $this->diesalOpB = $value;
        return $this;
    }

    public function getDiesalRequired(): ?string
    {
        return $this->diesalRequired;
    }

    public function setDiesalRequired(?string $value): static
    {
        $this->diesalRequired = $value;
        return $this;
    }

    public function getDiesalFill(): string
    {
        return $this->diesalFill;
    }

    public function setDiesalFill(string $value): static
    {
        $this->diesalFill = $value;
        return $this;
    }

    public function getDiesalAmount(): string
    {
        return $this->diesalAmount;
    }

    public function setDiesalAmount(string $value): static
    {
        $this->diesalAmount = $value;
        return $this;
    }

    public function getDiesalClBalance(): string
    {
        return $this->diesalClBalance;
    }

    public function setDiesalClBalance(string $value): static
    {
        $this->diesalClBalance = $value;
        return $this;
    }

    public function getVehicleAverage(): string
    {
        return $this->vehicleAverage;
    }

    public function setVehicleAverage(string $value): static
    {
        $this->vehicleAverage = $value;
        return $this;
    }

    public function getCashRequired(): ?string
    {
        return $this->cashRequired;
    }

    public function setCashRequired(?string $value): static
    {
        $this->cashRequired = $value;
        return $this;
    }

    public function getCashOpB(): string
    {
        return $this->cashOpB;
    }

    public function setCashOpB(string $value): static
    {
        $this->cashOpB = $value;
        return $this;
    }

    public function getCashPaid(): string
    {
        return $this->cashPaid;
    }

    public function setCashPaid(string $value): static
    {
        $this->cashPaid = $value;
        return $this;
    }

    public function getCashExpenses(): string
    {
        return $this->cashExpenses;
    }

    public function setCashExpenses(string $value): static
    {
        $this->cashExpenses = $value;
        return $this;
    }

    public function getCashClBalance(): string
    {
        return $this->cashClBalance;
    }

    public function setCashClBalance(string $value): static
    {
        $this->cashClBalance = $value;
        return $this;
    }

    public function getFasttagOpB(): ?string
    {
        return $this->fasttagOpB;
    }

    public function setFasttagOpB(?string $value): static
    {
        $this->fasttagOpB = $value;
        return $this;
    }

    public function getFasttagRecharge(): ?string
    {
        return $this->fasttagRecharge;
    }

    public function setFasttagRecharge(?string $value): static
    {
        $this->fasttagRecharge = $value;
        return $this;
    }

    public function getFasttagExpenses(): ?string
    {
        return $this->fasttagExpenses;
    }

    public function setFasttagExpenses(?string $value): static
    {
        $this->fasttagExpenses = $value;
        return $this;
    }

    public function getTollExpensesCash(): ?string
    {
        return $this->tollExpensesCash;
    }

    public function setTollExpensesCash(?string $value): static
    {
        $this->tollExpensesCash = $value;
        return $this;
    }

    public function getFasttagClBalance(): ?string
    {
        return $this->fasttagClBalance;
    }

    public function setFasttagClBalance(?string $value): static
    {
        $this->fasttagClBalance = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getConsignor(): int
    {
        return $this->consignor;
    }

    public function setConsignor(int $value): static
    {
        $this->consignor = $value;
        return $this;
    }

    public function getVehicleFreightComm(): string
    {
        return $this->vehicleFreightComm;
    }

    public function setVehicleFreightComm(string $value): static
    {
        $this->vehicleFreightComm = $value;
        return $this;
    }

    public function getVehicleFreightType(): int
    {
        return $this->vehicleFreightType;
    }

    public function setVehicleFreightType(int $value): static
    {
        $this->vehicleFreightType = $value;
        return $this;
    }

    public function getVehicleFreightAmount(): string
    {
        return $this->vehicleFreightAmount;
    }

    public function setVehicleFreightAmount(string $value): static
    {
        $this->vehicleFreightAmount = $value;
        return $this;
    }

    public function getVehicleFreightFinal(): string
    {
        return $this->vehicleFreightFinal;
    }

    public function setVehicleFreightFinal(string $value): static
    {
        $this->vehicleFreightFinal = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getExpensesId(): int
    {
        return $this->expensesId;
    }

    public function setExpensesId(int $value): static
    {
        $this->expensesId = $value;
        return $this;
    }
}
