<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_expenses_report" table
 */
#[Entity]
#[Table(name: "t_trip_expenses_report")]
class TTripExpensesReport extends AbstractEntity
{
    #[Column(type: "decimal")]
    private string $trip;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(type: "smallint", nullable: true)]
    private ?int $vehicle;

    #[Column(name: "unload_date", type: "datetime", nullable: true)]
    private ?DateTime $unloadDate;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal", nullable: true)]
    private ?string $out;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "per_km", type: "decimal", nullable: true)]
    private ?string $perKm;

    public function __construct()
    {
        $this->trip = "0";
        $this->driver = 0;
    }

    public function getTrip(): string
    {
        return $this->trip;
    }

    public function setTrip(string $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getVehicle(): ?int
    {
        return $this->vehicle;
    }

    public function setVehicle(?int $value): static
    {
        $this->vehicle = $value;
        return $this;
    }

    public function getUnloadDate(): ?DateTime
    {
        return $this->unloadDate;
    }

    public function setUnloadDate(?DateTime $value): static
    {
        $this->unloadDate = $value;
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): ?string
    {
        return $this->out;
    }

    public function setOut(?string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getPerKm(): ?string
    {
        return $this->perKm;
    }

    public function setPerKm(?string $value): static
    {
        $this->perKm = $value;
        return $this;
    }
}
