<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_expenses_detailed" table
 */
#[Entity]
#[Table(name: "t_trip_expenses_detailed")]
class TTripExpensesDetailed extends AbstractEntity
{
    #[Column(type: "smallint")]
    private int $id;

    #[Column(type: "decimal")]
    private string $trip;

    #[Column(name: "diesal_by", type: "decimal", nullable: true)]
    private ?string $diesalBy;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal", nullable: true)]
    private ?string $out;

    #[Column(type: "datetime")]
    private DateTime $dated;

    #[Column(type: "text", nullable: true)]
    private ?string $remarks;

    #[Column(name: "`table`", options: ["name" => "table"], type: "string")]
    private string $table;

    public function __construct()
    {
        $this->id = 0;
        $this->trip = "0";
        $this->in = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTrip(): string
    {
        return $this->trip;
    }

    public function setTrip(string $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getDiesalBy(): ?string
    {
        return $this->diesalBy;
    }

    public function setDiesalBy(?string $value): static
    {
        $this->diesalBy = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): ?string
    {
        return $this->out;
    }

    public function setOut(?string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getTable(): string
    {
        return HtmlDecode($this->table);
    }

    public function setTable(string $value): static
    {
        $this->table = RemoveXss($value);
        return $this;
    }
}
