<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_buyer" table
 */
#[Entity]
#[Table(name: "t_trip_buyer")]
class TTripBuyer extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "route_name", type: "string", nullable: true)]
    private ?string $routeName;

    #[Column(type: "smallint")]
    private int $buyer;

    #[Column(name: "delivery_receipt", type: "string", nullable: true)]
    private ?string $deliveryReceipt;

    #[Column(name: "delivery_docket", type: "string", nullable: true)]
    private ?string $deliveryDocket;

    #[Column(name: "invoice_no", type: "smallint")]
    private int $invoiceNo;

    #[Column(name: "invoice_date", type: "date", nullable: true)]
    private ?DateTime $invoiceDate;

    public function __construct()
    {
        $this->invoiceNo = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRouteName(): ?string
    {
        return HtmlDecode($this->routeName);
    }

    public function setRouteName(?string $value): static
    {
        $this->routeName = RemoveXss($value);
        return $this;
    }

    public function getBuyer(): int
    {
        return $this->buyer;
    }

    public function setBuyer(int $value): static
    {
        $this->buyer = $value;
        return $this;
    }

    public function getDeliveryReceipt(): ?string
    {
        return HtmlDecode($this->deliveryReceipt);
    }

    public function setDeliveryReceipt(?string $value): static
    {
        $this->deliveryReceipt = RemoveXss($value);
        return $this;
    }

    public function getDeliveryDocket(): ?string
    {
        return HtmlDecode($this->deliveryDocket);
    }

    public function setDeliveryDocket(?string $value): static
    {
        $this->deliveryDocket = RemoveXss($value);
        return $this;
    }

    public function getInvoiceNo(): int
    {
        return $this->invoiceNo;
    }

    public function setInvoiceNo(int $value): static
    {
        $this->invoiceNo = $value;
        return $this;
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?DateTime $value): static
    {
        $this->invoiceDate = $value;
        return $this;
    }
}
