<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_trip_balance" table
 */
#[Entity]
#[Table(name: "t_trip_balance")]
class TTripBalance extends AbstractEntity
{
    #[Column(type: "bigint", nullable: true)]
    private ?string $trip;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "route_name", type: "string", nullable: true)]
    private ?string $routeName;

    #[Column(name: "r_from", type: "decimal", nullable: true)]
    private ?string $rFrom;

    public function __construct()
    {
        $this->trip = "0";
    }

    public function getTrip(): ?string
    {
        return $this->trip;
    }

    public function setTrip(?string $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getRouteName(): ?string
    {
        return HtmlDecode($this->routeName);
    }

    public function setRouteName(?string $value): static
    {
        $this->routeName = RemoveXss($value);
        return $this;
    }

    public function getRFrom(): ?string
    {
        return $this->rFrom;
    }

    public function setRFrom(?string $value): static
    {
        $this->rFrom = $value;
        return $this;
    }
}
