<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_route_info" table
 */
#[Entity]
#[Table(name: "t_route_info")]
class TRouteInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "route_name", type: "string", nullable: true)]
    private ?string $routeName;

    #[Column(name: "r_from", type: "string")]
    private string $rFrom;

    #[Column(name: "r_to", type: "string")]
    private string $rTo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $km;

    #[Column(type: "decimal", nullable: true)]
    private ?string $days;

    #[Column(name: "load_expenses", type: "integer", nullable: true)]
    private ?int $loadExpenses;

    #[Column(name: "unload_expenses", type: "integer")]
    private int $unloadExpenses;

    #[Column(type: "smallint")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRouteName(): ?string
    {
        return HtmlDecode($this->routeName);
    }

    public function setRouteName(?string $value): static
    {
        $this->routeName = RemoveXss($value);
        return $this;
    }

    public function getRFrom(): string
    {
        return HtmlDecode($this->rFrom);
    }

    public function setRFrom(string $value): static
    {
        $this->rFrom = RemoveXss($value);
        return $this;
    }

    public function getRTo(): string
    {
        return HtmlDecode($this->rTo);
    }

    public function setRTo(string $value): static
    {
        $this->rTo = RemoveXss($value);
        return $this;
    }

    public function getKm(): ?int
    {
        return $this->km;
    }

    public function setKm(?int $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getDays(): ?string
    {
        return $this->days;
    }

    public function setDays(?string $value): static
    {
        $this->days = $value;
        return $this;
    }

    public function getLoadExpenses(): ?int
    {
        return $this->loadExpenses;
    }

    public function setLoadExpenses(?int $value): static
    {
        $this->loadExpenses = $value;
        return $this;
    }

    public function getUnloadExpenses(): int
    {
        return $this->unloadExpenses;
    }

    public function setUnloadExpenses(int $value): static
    {
        $this->unloadExpenses = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
