<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_maintenance" table
 */
#[Entity]
#[Table(name: "t_maintenance")]
class TMaintenance extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "vehicle_no", type: "smallint")]
    private int $vehicleNo;

    #[Column(type: "smallint")]
    private int $head;

    #[Column(name: "sub_head", type: "smallint", nullable: true)]
    private ?int $subHead;

    #[Column(type: "integer")]
    private int $km;

    #[Column(name: "life_km", type: "integer")]
    private int $lifeKm;

    #[Column(name: "next_km", type: "integer")]
    private int $nextKm;

    #[Column(name: "s_no", type: "string", nullable: true)]
    private ?string $sNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "update_id", type: "integer", nullable: true)]
    private ?int $updateId;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(type: "string")]
    private string $remarks;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleNo(): int
    {
        return $this->vehicleNo;
    }

    public function setVehicleNo(int $value): static
    {
        $this->vehicleNo = $value;
        return $this;
    }

    public function getHead(): int
    {
        return $this->head;
    }

    public function setHead(int $value): static
    {
        $this->head = $value;
        return $this;
    }

    public function getSubHead(): ?int
    {
        return $this->subHead;
    }

    public function setSubHead(?int $value): static
    {
        $this->subHead = $value;
        return $this;
    }

    public function getKm(): int
    {
        return $this->km;
    }

    public function setKm(int $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getLifeKm(): int
    {
        return $this->lifeKm;
    }

    public function setLifeKm(int $value): static
    {
        $this->lifeKm = $value;
        return $this;
    }

    public function getNextKm(): int
    {
        return $this->nextKm;
    }

    public function setNextKm(int $value): static
    {
        $this->nextKm = $value;
        return $this;
    }

    public function getSNo(): ?string
    {
        return HtmlDecode($this->sNo);
    }

    public function setSNo(?string $value): static
    {
        $this->sNo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUpdateId(): ?int
    {
        return $this->updateId;
    }

    public function setUpdateId(?int $value): static
    {
        $this->updateId = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
