<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_ledger" table
 */
#[Entity]
#[Table(name: "t_ledger")]
class TLedger extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $uid;

    #[Column(type: "datetime")]
    private DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(name: "cumulative_sum", type: "decimal", nullable: true)]
    private ?string $cumulativeSum;

    #[Column(type: "string")]
    private string $trip;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "r_from", type: "integer", nullable: true)]
    private ?int $rFrom;

    #[Column(type: "integer", nullable: true)]
    private ?int $id;

    public function __construct()
    {
        $this->trip = "0";
        $this->id = 0;
    }

    public function getUid(): int
    {
        return $this->uid;
    }

    public function setUid(int $value): static
    {
        $this->uid = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getCumulativeSum(): ?string
    {
        return $this->cumulativeSum;
    }

    public function setCumulativeSum(?string $value): static
    {
        $this->cumulativeSum = $value;
        return $this;
    }

    public function getTrip(): string
    {
        return HtmlDecode($this->trip);
    }

    public function setTrip(string $value): static
    {
        $this->trip = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getRFrom(): ?int
    {
        return $this->rFrom;
    }

    public function setRFrom(?int $value): static
    {
        $this->rFrom = $value;
        return $this;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $value): static
    {
        $this->id = $value;
        return $this;
    }
}
