<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_expenses" table
 */
#[Entity]
#[Table(name: "t_expenses")]
class TExpense extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", unique: true)]
    private int $trip;

    #[Column(type: "decimal")]
    private string $diesal;

    #[Column(type: "decimal")]
    private string $border;

    #[Column(type: "decimal")]
    private string $rto;

    #[Column(type: "decimal")]
    private string $da;

    #[Column(type: "decimal")]
    private string $repairing;

    #[Column(type: "decimal")]
    private string $toll;

    #[Column(type: "decimal")]
    private string $other;

    #[Column(type: "decimal")]
    private string $total;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "diesal_lt", type: "decimal")]
    private string $diesalLt;

    #[Column(type: "decimal")]
    private string $def;

    public function __construct()
    {
        $this->diesal = "0";
        $this->border = "0";
        $this->rto = "0";
        $this->da = "0";
        $this->repairing = "0";
        $this->toll = "0.00";
        $this->other = "0";
        $this->total = "0.00";
        $this->operator = 0;
        $this->diesalLt = "0.00";
        $this->def = "0.00";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTrip(): int
    {
        return $this->trip;
    }

    public function setTrip(int $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getDiesal(): string
    {
        return $this->diesal;
    }

    public function setDiesal(string $value): static
    {
        $this->diesal = $value;
        return $this;
    }

    public function getBorder(): string
    {
        return $this->border;
    }

    public function setBorder(string $value): static
    {
        $this->border = $value;
        return $this;
    }

    public function getRto(): string
    {
        return $this->rto;
    }

    public function setRto(string $value): static
    {
        $this->rto = $value;
        return $this;
    }

    public function getDa(): string
    {
        return $this->da;
    }

    public function setDa(string $value): static
    {
        $this->da = $value;
        return $this;
    }

    public function getRepairing(): string
    {
        return $this->repairing;
    }

    public function setRepairing(string $value): static
    {
        $this->repairing = $value;
        return $this;
    }

    public function getToll(): string
    {
        return $this->toll;
    }

    public function setToll(string $value): static
    {
        $this->toll = $value;
        return $this;
    }

    public function getOther(): string
    {
        return $this->other;
    }

    public function setOther(string $value): static
    {
        $this->other = $value;
        return $this;
    }

    public function getTotal(): string
    {
        return $this->total;
    }

    public function setTotal(string $value): static
    {
        $this->total = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getDiesalLt(): string
    {
        return $this->diesalLt;
    }

    public function setDiesalLt(string $value): static
    {
        $this->diesalLt = $value;
        return $this;
    }

    public function getDef(): string
    {
        return $this->def;
    }

    public function setDef(string $value): static
    {
        $this->def = $value;
        return $this;
    }
}
