<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_due_payment" table
 */
#[Entity]
#[Table(name: "t_due_payment")]
class TDuePayment extends AbstractEntity
{
    #[Column(name: "r_from", type: "decimal", nullable: true)]
    private ?string $rFrom;

    #[Column(name: "Party", type: "string", nullable: true)]
    private ?string $party;

    #[Column(name: "Reference", type: "string", nullable: true)]
    private ?string $reference;

    #[Column(name: "Amount", type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(name: "Receipt", type: "decimal", nullable: true)]
    private ?string $receipt;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    public function getRFrom(): ?string
    {
        return $this->rFrom;
    }

    public function setRFrom(?string $value): static
    {
        $this->rFrom = $value;
        return $this;
    }

    public function getParty(): ?string
    {
        return HtmlDecode($this->party);
    }

    public function setParty(?string $value): static
    {
        $this->party = RemoveXss($value);
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getReceipt(): ?string
    {
        return $this->receipt;
    }

    public function setReceipt(?string $value): static
    {
        $this->receipt = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }
}
