<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_diesal_expenses_d" table
 */
#[Entity]
#[Table(name: "t_diesal_expenses_d")]
class TDiesalExpensesD extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $trip;

    #[Column(type: "smallint")]
    private int $litre;

    #[Column(type: "integer", nullable: true)]
    private ?int $amount;

    #[Column(type: "decimal")]
    private string $km;

    #[Column(name: "diesal_by", type: "integer", nullable: true)]
    private ?int $diesalBy;

    #[Column(type: "string", nullable: true)]
    private ?string $remakrs;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->trip = Trip_ID();
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTrip(): int
    {
        return $this->trip;
    }

    public function setTrip(int $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getLitre(): int
    {
        return $this->litre;
    }

    public function setLitre(int $value): static
    {
        $this->litre = $value;
        return $this;
    }

    public function getAmount(): ?int
    {
        return $this->amount;
    }

    public function setAmount(?int $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getKm(): string
    {
        return $this->km;
    }

    public function setKm(string $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getDiesalBy(): ?int
    {
        return $this->diesalBy;
    }

    public function setDiesalBy(?int $value): static
    {
        $this->diesalBy = $value;
        return $this;
    }

    public function getRemakrs(): ?string
    {
        return HtmlDecode($this->remakrs);
    }

    public function setRemakrs(?string $value): static
    {
        $this->remakrs = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
