<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_daily_km" table
 */
#[Entity]
#[Table(name: "t_daily_km")]
class TDailyKm extends AbstractEntity
{
    #[Id]
    #[Column(type: "bigint", unique: true)]
    #[GeneratedValue]
    private string $id;

    #[Column(name: "vehicle_no", type: "integer")]
    private int $vehicleNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $trip;

    #[Column(type: "smallint", nullable: true)]
    private ?int $driver;

    #[Column(name: "old_km", type: "float", nullable: true)]
    private ?float $oldKm;

    #[Column(type: "float")]
    private float $km;

    #[Column(type: "float", nullable: true)]
    private ?float $run;

    #[Column(type: "datetime")]
    private DateTime $dated;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getVehicleNo(): int
    {
        return $this->vehicleNo;
    }

    public function setVehicleNo(int $value): static
    {
        $this->vehicleNo = $value;
        return $this;
    }

    public function getTrip(): ?int
    {
        return $this->trip;
    }

    public function setTrip(?int $value): static
    {
        $this->trip = $value;
        return $this;
    }

    public function getDriver(): ?int
    {
        return $this->driver;
    }

    public function setDriver(?int $value): static
    {
        $this->driver = $value;
        return $this;
    }

    public function getOldKm(): ?float
    {
        return $this->oldKm;
    }

    public function setOldKm(?float $value): static
    {
        $this->oldKm = $value;
        return $this;
    }

    public function getKm(): float
    {
        return $this->km;
    }

    public function setKm(float $value): static
    {
        $this->km = $value;
        return $this;
    }

    public function getRun(): ?float
    {
        return $this->run;
    }

    public function setRun(?float $value): static
    {
        $this->run = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
