<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "t_balance" table
 */
#[Entity]
#[Table(name: "t_balance")]
class TBalance extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "float", nullable: true)]
    private ?float $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal", nullable: true)]
    private ?string $out;

    #[Column(name: "Balance", type: "float", nullable: true)]
    private ?float $balance;

    #[Column(name: "r_from", type: "decimal", nullable: true)]
    private ?string $rFrom;

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getIn(): ?float
    {
        return $this->in;
    }

    public function setIn(?float $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): ?string
    {
        return $this->out;
    }

    public function setOut(?string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): ?float
    {
        return $this->balance;
    }

    public function setBalance(?float $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getRFrom(): ?string
    {
        return $this->rFrom;
    }

    public function setRFrom(?string $value): static
    {
        $this->rFrom = $value;
        return $this;
    }
}
