<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "subscriptions" table
 */
#[Entity]
#[Table(name: "subscriptions")]
class Subscription extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $user;

    #[Column(type: "text")]
    private string $endpoint;

    #[Column(type: "string")]
    private string $publickey;

    #[Column(type: "string")]
    private string $authenticationtoken;

    #[Column(type: "string")]
    private string $contentencoding;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUser(): ?string
    {
        return HtmlDecode($this->user);
    }

    public function setUser(?string $value): static
    {
        $this->user = RemoveXss($value);
        return $this;
    }

    public function getEndpoint(): string
    {
        return HtmlDecode($this->endpoint);
    }

    public function setEndpoint(string $value): static
    {
        $this->endpoint = RemoveXss($value);
        return $this;
    }

    public function getPublickey(): string
    {
        return HtmlDecode($this->publickey);
    }

    public function setPublickey(string $value): static
    {
        $this->publickey = RemoveXss($value);
        return $this;
    }

    public function getAuthenticationtoken(): string
    {
        return HtmlDecode($this->authenticationtoken);
    }

    public function setAuthenticationtoken(string $value): static
    {
        $this->authenticationtoken = RemoveXss($value);
        return $this;
    }

    public function getContentencoding(): string
    {
        return HtmlDecode($this->contentencoding);
    }

    public function setContentencoding(string $value): static
    {
        $this->contentencoding = RemoveXss($value);
        return $this;
    }
}
