<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_setup" table
 */
#[Entity]
#[Table(name: "stock_setup")]
class StockSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "date_from", type: "datetime")]
    private DateTime $dateFrom;

    #[Column(name: "date_to", type: "datetime")]
    private DateTime $dateTo;

    #[Column(name: "lot_type_processing_outside", type: "integer")]
    private int $lotTypeProcessingOutside;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "stock_complete_lot_id", type: "string", nullable: true)]
    private ?string $stockCompleteLotId;

    public function __construct()
    {
        $this->lotTypeProcessingOutside = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getDateFrom(): DateTime
    {
        return $this->dateFrom;
    }

    public function setDateFrom(DateTime $value): static
    {
        $this->dateFrom = $value;
        return $this;
    }

    public function getDateTo(): DateTime
    {
        return $this->dateTo;
    }

    public function setDateTo(DateTime $value): static
    {
        $this->dateTo = $value;
        return $this;
    }

    public function getLotTypeProcessingOutside(): int
    {
        return $this->lotTypeProcessingOutside;
    }

    public function setLotTypeProcessingOutside(int $value): static
    {
        $this->lotTypeProcessingOutside = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getStockCompleteLotId(): ?string
    {
        return HtmlDecode($this->stockCompleteLotId);
    }

    public function setStockCompleteLotId(?string $value): static
    {
        $this->stockCompleteLotId = RemoveXss($value);
        return $this;
    }
}
