<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_process" table
 */
#[Entity]
#[Table(name: "stock_process")]
class StockProcess extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "string")]
    private string $code;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "integer")]
    private int $out;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(name: "tmp_lot", type: "string")]
    private string $tmpLot;

    #[Column(type: "string")]
    private string $url;

    #[Column(type: "integer")]
    private int $age;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "string")]
    private string $type;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    public function __construct()
    {
        $this->out = 0;
        $this->age = 0;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): int
    {
        return $this->out;
    }

    public function setOut(int $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getTmpLot(): string
    {
        return HtmlDecode($this->tmpLot);
    }

    public function setTmpLot(string $value): static
    {
        $this->tmpLot = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getAge(): int
    {
        return $this->age;
    }

    public function setAge(int $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
