<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_packing" table
 */
#[Entity]
#[Table(name: "stock_packing")]
class StockPacking extends AbstractEntity
{
    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "integer")]
    private int $out;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "tmp_lot", type: "decimal", nullable: true)]
    private ?string $tmpLot;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    public function __construct()
    {
        $this->out = 0;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): int
    {
        return $this->out;
    }

    public function setOut(int $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getTmpLot(): ?string
    {
        return $this->tmpLot;
    }

    public function setTmpLot(?string $value): static
    {
        $this->tmpLot = $value;
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
