<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_online" table
 */
#[Entity]
#[Table(name: "stock_online")]
class StockOnline extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "smallint")]
    private int $location;

    #[Column(type: "integer", nullable: true)]
    private ?int $barcode;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(name: "Remarks", type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "last_remarks", type: "string", nullable: true)]
    private ?string $lastRemarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "consumed_by", type: "string", nullable: true)]
    private ?string $consumedBy;

    #[Column(name: "consumed_sqm", type: "decimal", nullable: true)]
    private ?string $consumedSqm;

    #[Column(name: "consumed_status", type: "decimal", nullable: true)]
    private ?string $consumedStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $category;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    public function __construct()
    {
        $this->location = 0;
        $this->barcode = 0;
        $this->status = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): int
    {
        return $this->location;
    }

    public function setLocation(int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getBarcode(): ?int
    {
        return $this->barcode;
    }

    public function setBarcode(?int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getLastRemarks(): ?string
    {
        return HtmlDecode($this->lastRemarks);
    }

    public function setLastRemarks(?string $value): static
    {
        $this->lastRemarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getConsumedBy(): ?string
    {
        return HtmlDecode($this->consumedBy);
    }

    public function setConsumedBy(?string $value): static
    {
        $this->consumedBy = RemoveXss($value);
        return $this;
    }

    public function getConsumedSqm(): ?string
    {
        return $this->consumedSqm;
    }

    public function setConsumedSqm(?string $value): static
    {
        $this->consumedSqm = $value;
        return $this;
    }

    public function getConsumedStatus(): ?string
    {
        return $this->consumedStatus;
    }

    public function setConsumedStatus(?string $value): static
    {
        $this->consumedStatus = $value;
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
