<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_lcgp" table
 */
#[Entity]
#[Table(name: "stock_lcgp")]
class StockLcgp extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $id;

    #[Column(type: "bigint", nullable: true)]
    private ?string $rid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(name: "product_code_pg", type: "string", nullable: true)]
    private ?string $productCodePg;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "decimal", nullable: true)]
    private ?string $godown;

    #[Column(name: "godown_n", type: "string", nullable: true)]
    private ?string $godownN;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal", nullable: true)]
    private ?string $out;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type_n", type: "string", nullable: true)]
    private ?string $packingTypeN;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "packing_type", type: "decimal", nullable: true)]
    private ?string $packingType;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    #[Column(name: "HOLD", type: "decimal", nullable: true)]
    private ?string $hold;

    #[Column(name: "avg_quantity", type: "decimal")]
    private string $avgQuantity;

    #[Column(name: "`@`", options: ["name" => "@"], type: "string", nullable: true)]
    private ?string $40;

    #[Column(type: "string", nullable: true)]
    private ?string $age;

    #[Column(name: "company_id", type: "decimal", nullable: true)]
    private ?string $companyId;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    public function __construct()
    {
        $this->packingType = "0";
    }

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getRid(): ?string
    {
        return $this->rid;
    }

    public function setRid(?string $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getProductCodePg(): ?string
    {
        return HtmlDecode($this->productCodePg);
    }

    public function setProductCodePg(?string $value): static
    {
        $this->productCodePg = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getGodown(): ?string
    {
        return $this->godown;
    }

    public function setGodown(?string $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getGodownN(): ?string
    {
        return HtmlDecode($this->godownN);
    }

    public function setGodownN(?string $value): static
    {
        $this->godownN = RemoveXss($value);
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): ?string
    {
        return $this->out;
    }

    public function setOut(?string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingTypeN(): ?string
    {
        return HtmlDecode($this->packingTypeN);
    }

    public function setPackingTypeN(?string $value): static
    {
        $this->packingTypeN = RemoveXss($value);
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): ?string
    {
        return $this->packingType;
    }

    public function setPackingType(?string $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getHold(): ?string
    {
        return $this->hold;
    }

    public function setHold(?string $value): static
    {
        $this->hold = $value;
        return $this;
    }

    public function getAvgQuantity(): string
    {
        return $this->avgQuantity;
    }

    public function setAvgQuantity(string $value): static
    {
        $this->avgQuantity = $value;
        return $this;
    }

    public function get40(): ?string
    {
        return HtmlDecode($this->40);
    }

    public function set40(?string $value): static
    {
        $this->40 = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): ?string
    {
        return $this->companyId;
    }

    public function setCompanyId(?string $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }
}
