<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "stock_datewise" table
 */
#[Entity]
#[Table(name: "stock_datewise")]
class StockDatewise extends AbstractEntity
{
    #[Column(type: "decimal", nullable: true)]
    private ?string $product;

    #[Column(type: "decimal", nullable: true)]
    private ?string $rid;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "`IN`", options: ["name" => "IN"], type: "decimal", nullable: true)]
    private ?string $in;

    #[Column(name: "`OUT`", options: ["name" => "OUT"], type: "decimal", nullable: true)]
    private ?string $out;

    #[Column(type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(type: "decimal", nullable: true)]
    private ?string $packets;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "string", nullable: true)]
    private ?string $dated;

    #[Column(type: "string")]
    private string $type;

    #[Column(type: "string", nullable: true)]
    private ?string $age;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    public function __construct()
    {
        $this->packingType = 0;
    }

    public function getProduct(): ?string
    {
        return $this->product;
    }

    public function setProduct(?string $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return $this->rid;
    }

    public function setRid(?string $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getIn(): ?string
    {
        return $this->in;
    }

    public function setIn(?string $value): static
    {
        $this->in = $value;
        return $this;
    }

    public function getOut(): ?string
    {
        return $this->out;
    }

    public function setOut(?string $value): static
    {
        $this->out = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getPackets(): ?string
    {
        return $this->packets;
    }

    public function setPackets(?string $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?string
    {
        return HtmlDecode($this->dated);
    }

    public function setDated(?string $value): static
    {
        $this->dated = RemoveXss($value);
        return $this;
    }

    public function getType(): string
    {
        return HtmlDecode($this->type);
    }

    public function setType(string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
